/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.TagAttributesBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TagList
implements JsonSerializable<TagList> {
    private String registryLoginServer;
    private String repository;
    private List<TagAttributesBase> tagAttributeBases;
    private String link;

    public String getRegistryLoginServer() {
        return this.registryLoginServer;
    }

    public TagList setRegistryLoginServer(String registryLoginServer) {
        this.registryLoginServer = registryLoginServer;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public TagList setRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public List<TagAttributesBase> getTagAttributeBases() {
        return this.tagAttributeBases;
    }

    public TagList setTagAttributeBases(List<TagAttributesBase> tagAttributeBases) {
        this.tagAttributeBases = tagAttributeBases;
        return this;
    }

    public String getLink() {
        return this.link;
    }

    public TagList setLink(String link) {
        this.link = link;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registry", this.registryLoginServer);
        jsonWriter.writeStringField("imageName", this.repository);
        jsonWriter.writeArrayField("tags", this.tagAttributeBases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("link", this.link);
        return jsonWriter.writeEndObject();
    }

    public static TagList fromJson(JsonReader jsonReader) throws IOException {
        return (TagList)jsonReader.readObject(reader -> {
            TagList deserializedTagList = new TagList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registry".equals(fieldName)) {
                    deserializedTagList.registryLoginServer = reader.getString();
                    continue;
                }
                if ("imageName".equals(fieldName)) {
                    deserializedTagList.repository = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tagAttributeBases;
                    deserializedTagList.tagAttributeBases = tagAttributeBases = reader.readArray(reader1 -> TagAttributesBase.fromJson(reader1));
                    continue;
                }
                if ("link".equals(fieldName)) {
                    deserializedTagList.link = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagList;
        });
    }
}

