/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.Manifest;
import com.azure.containers.containerregistry.implementation.models.ManifestListAttributes;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ManifestList
extends Manifest {
    private String mediaType;
    private List<ManifestListAttributes> manifests;

    public String getMediaType() {
        return this.mediaType;
    }

    public ManifestList setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public List<ManifestListAttributes> getManifests() {
        return this.manifests;
    }

    public ManifestList setManifests(List<ManifestListAttributes> manifests) {
        this.manifests = manifests;
        return this;
    }

    @Override
    public ManifestList setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", (Number)this.getSchemaVersion());
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeArrayField("manifests", this.manifests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManifestList fromJson(JsonReader jsonReader) throws IOException {
        return (ManifestList)jsonReader.readObject(reader -> {
            ManifestList deserializedManifestList = new ManifestList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedManifestList.setSchemaVersion((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("mediaType".equals(fieldName)) {
                    deserializedManifestList.mediaType = reader.getString();
                    continue;
                }
                if ("manifests".equals(fieldName)) {
                    List manifests;
                    deserializedManifestList.manifests = manifests = reader.readArray(reader1 -> ManifestListAttributes.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManifestList;
        });
    }
}

