/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.JWK;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageSignature
implements JsonSerializable<ImageSignature> {
    private JWK headerProperty;
    private String signature;
    private String protectedProperty;

    public JWK getHeaderProperty() {
        return this.headerProperty;
    }

    public ImageSignature setHeaderProperty(JWK headerProperty) {
        this.headerProperty = headerProperty;
        return this;
    }

    public String getSignature() {
        return this.signature;
    }

    public ImageSignature setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public String getProtectedProperty() {
        return this.protectedProperty;
    }

    public ImageSignature setProtectedProperty(String protectedProperty) {
        this.protectedProperty = protectedProperty;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("header", (JsonSerializable)this.headerProperty);
        jsonWriter.writeStringField("signature", this.signature);
        jsonWriter.writeStringField("protected", this.protectedProperty);
        return jsonWriter.writeEndObject();
    }

    public static ImageSignature fromJson(JsonReader jsonReader) throws IOException {
        return (ImageSignature)jsonReader.readObject(reader -> {
            ImageSignature deserializedImageSignature = new ImageSignature();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("header".equals(fieldName)) {
                    deserializedImageSignature.headerProperty = JWK.fromJson(reader);
                    continue;
                }
                if ("signature".equals(fieldName)) {
                    deserializedImageSignature.signature = reader.getString();
                    continue;
                }
                if ("protected".equals(fieldName)) {
                    deserializedImageSignature.protectedProperty = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageSignature;
        });
    }
}

