/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.authentication;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;

class JsonWebToken {
    JsonWebToken() {
    }

    public static OffsetDateTime retrieveExpiration(String jwtValue) {
        OffsetDateTime offsetDateTime;
        block12: {
            if (CoreUtils.isNullOrEmpty((CharSequence)jwtValue)) {
                throw new IllegalArgumentException("Value cannot be null or empty: 'jwtValue'.");
            }
            int firstIndex = jwtValue.indexOf(46);
            if (firstIndex == -1) {
                return null;
            }
            int secondIndex = jwtValue.indexOf(46, firstIndex + 1);
            if (secondIndex == -1) {
                return null;
            }
            String jwtPayloadEncoded = jwtValue.substring(firstIndex + 1, secondIndex);
            if (CoreUtils.isNullOrEmpty((CharSequence)jwtPayloadEncoded)) {
                return null;
            }
            JsonReader jsonReader = JsonProviders.createReader((byte[])Base64.getDecoder().decode(jwtPayloadEncoded));
            try {
                Long expirationValue = (Long)jsonReader.readObject(reader -> {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if (!"exp".equals(fieldName)) continue;
                        return reader.getLong();
                    }
                    return null;
                });
                OffsetDateTime offsetDateTime2 = offsetDateTime = expirationValue == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochSecond(expirationValue), ZoneOffset.UTC);
                if (jsonReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return null;
                }
            }
            jsonReader.close();
        }
        return offsetDateTime;
    }
}

