/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCheckBlobExistsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCheckChunkExistsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCompleteUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsDeleteBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetChunkHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetUploadStatusHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsMountBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsStartUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsUploadChunkHeaders;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainerRegistryBlobsImpl {
    private final ContainerRegistryBlobsService service;
    private final AzureContainerRegistryImpl client;

    ContainerRegistryBlobsImpl(AzureContainerRegistryImpl client) {
        this.service = (ContainerRegistryBlobsService)RestProxy.create(ContainerRegistryBlobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlobWithResponseAsync(String name, String digest) {
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getBlob(this.client.getUrl(), name, digest, "application/octet-stream", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlobWithResponseAsync(String name, String digest, Context context) {
        String accept = "application/octet-stream";
        return this.service.getBlob(this.client.getUrl(), name, digest, "application/octet-stream", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getBlobAsync(String name, String digest) {
        return this.getBlobWithResponseAsync(name, digest).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getBlobAsync(String name, String digest, Context context) {
        return this.getBlobWithResponseAsync(name, digest, context).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData> getBlobWithResponse(String name, String digest, Context context) {
        String accept = "application/octet-stream";
        return this.service.getBlobSync(this.client.getUrl(), name, digest, "application/octet-stream", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getBlob(String name, String digest) {
        return (BinaryData)this.getBlobWithResponse(name, digest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>> checkBlobExistsWithResponseAsync(String name, String digest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkBlobExists(this.client.getUrl(), name, digest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>> checkBlobExistsWithResponseAsync(String name, String digest, Context context) {
        String accept = "application/json";
        return this.service.checkBlobExists(this.client.getUrl(), name, digest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkBlobExistsAsync(String name, String digest) {
        return this.checkBlobExistsWithResponseAsync(name, digest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkBlobExistsAsync(String name, String digest, Context context) {
        return this.checkBlobExistsWithResponseAsync(name, digest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void> checkBlobExistsWithResponse(String name, String digest, Context context) {
        String accept = "application/json";
        return this.service.checkBlobExistsSync(this.client.getUrl(), name, digest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkBlobExists(String name, String digest) {
        this.checkBlobExistsWithResponse(name, digest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlobWithResponseAsync(String name, String digest) {
        return FluxUtil.withContext(context -> this.service.deleteBlob(this.client.getUrl(), name, digest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlobWithResponseAsync(String name, String digest, Context context) {
        return this.service.deleteBlob(this.client.getUrl(), name, digest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBlobAsync(String name, String digest) {
        return this.deleteBlobWithResponseAsync(name, digest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBlobAsync(String name, String digest, Context context) {
        return this.deleteBlobWithResponseAsync(name, digest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void> deleteBlobWithResponse(String name, String digest, Context context) {
        return this.service.deleteBlobSync(this.client.getUrl(), name, digest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBlob(String name, String digest) {
        this.deleteBlobWithResponse(name, digest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlobWithResponseAsync(String name, String from, String mount) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.mountBlob(this.client.getUrl(), name, from, mount, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlobWithResponseAsync(String name, String from, String mount, Context context) {
        String accept = "application/json";
        return this.service.mountBlob(this.client.getUrl(), name, from, mount, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> mountBlobAsync(String name, String from, String mount) {
        return this.mountBlobWithResponseAsync(name, from, mount).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> mountBlobAsync(String name, String from, String mount, Context context) {
        return this.mountBlobWithResponseAsync(name, from, mount, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void> mountBlobWithResponse(String name, String from, String mount, Context context) {
        String accept = "application/json";
        return this.service.mountBlobSync(this.client.getUrl(), name, from, mount, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void mountBlob(String name, String from, String mount) {
        this.mountBlobWithResponse(name, from, mount, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>> getUploadStatusWithResponseAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUploadStatus(this.client.getUrl(), nextLink, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>> getUploadStatusWithResponseAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getUploadStatus(this.client.getUrl(), nextLink, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getUploadStatusAsync(String nextLink) {
        return this.getUploadStatusWithResponseAsync(nextLink).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getUploadStatusAsync(String nextLink, Context context) {
        return this.getUploadStatusWithResponseAsync(nextLink, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void> getUploadStatusWithResponse(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getUploadStatusSync(this.client.getUrl(), nextLink, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getUploadStatus(String nextLink) {
        this.getUploadStatusWithResponse(nextLink, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunkWithResponseAsync(String nextLink, Flux<ByteBuffer> value, long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunkWithResponseAsync(String nextLink, Flux<ByteBuffer> value, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, Flux<ByteBuffer> value, long contentLength) {
        return this.uploadChunkWithResponseAsync(nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, Flux<ByteBuffer> value, long contentLength, Context context) {
        return this.uploadChunkWithResponseAsync(nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunkWithResponseAsync(String nextLink, BinaryData value, long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunkWithResponseAsync(String nextLink, BinaryData value, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, BinaryData value, long contentLength) {
        return this.uploadChunkWithResponseAsync(nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, BinaryData value, long contentLength, Context context) {
        return this.uploadChunkWithResponseAsync(nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void> uploadChunkWithResponse(String nextLink, BinaryData value, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.uploadChunkSync(this.client.getUrl(), nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadChunk(String nextLink, BinaryData value, long contentLength) {
        this.uploadChunkWithResponse(nextLink, value, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength) {
        return this.completeUploadWithResponseAsync(digest, nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength, Context context) {
        return this.completeUploadWithResponseAsync(digest, nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(String digest, String nextLink, BinaryData value, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(String digest, String nextLink, BinaryData value, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, BinaryData value, Long contentLength) {
        return this.completeUploadWithResponseAsync(digest, nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, BinaryData value, Long contentLength, Context context) {
        return this.completeUploadWithResponseAsync(digest, nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void> completeUploadWithResponse(String digest, String nextLink, BinaryData value, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.completeUploadSync(this.client.getUrl(), digest, nextLink, value, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void completeUpload(String digest, String nextLink, BinaryData value, Long contentLength) {
        this.completeUploadWithResponse(digest, nextLink, value, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelUploadWithResponseAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelUpload(this.client.getUrl(), nextLink, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelUploadWithResponseAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.cancelUpload(this.client.getUrl(), nextLink, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelUploadAsync(String nextLink) {
        return this.cancelUploadWithResponseAsync(nextLink).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelUploadAsync(String nextLink, Context context) {
        return this.cancelUploadWithResponseAsync(nextLink, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelUploadWithResponse(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.cancelUploadSync(this.client.getUrl(), nextLink, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelUpload(String nextLink) {
        this.cancelUploadWithResponse(nextLink, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>> startUploadWithResponseAsync(String name) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startUpload(this.client.getUrl(), name, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>> startUploadWithResponseAsync(String name, Context context) {
        String accept = "application/json";
        return this.service.startUpload(this.client.getUrl(), name, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startUploadAsync(String name) {
        return this.startUploadWithResponseAsync(name).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startUploadAsync(String name, Context context) {
        return this.startUploadWithResponseAsync(name, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void> startUploadWithResponse(String name, Context context) {
        String accept = "application/json";
        return this.service.startUploadSync(this.client.getUrl(), name, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startUpload(String name) {
        this.startUploadWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunkWithResponseAsync(String name, String digest, String range) {
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getChunk(this.client.getUrl(), name, digest, range, "application/octet-stream", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunkWithResponseAsync(String name, String digest, String range, Context context) {
        String accept = "application/octet-stream";
        return this.service.getChunk(this.client.getUrl(), name, digest, range, "application/octet-stream", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getChunkAsync(String name, String digest, String range) {
        return this.getChunkWithResponseAsync(name, digest, range).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getChunkAsync(String name, String digest, String range, Context context) {
        return this.getChunkWithResponseAsync(name, digest, range, context).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> getChunkWithResponse(String name, String digest, String range, Context context) {
        String accept = "application/octet-stream";
        return this.service.getChunkSync(this.client.getUrl(), name, digest, range, "application/octet-stream", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getChunk(String name, String digest, String range) {
        return (BinaryData)this.getChunkWithResponse(name, digest, range, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>> checkChunkExistsWithResponseAsync(String name, String digest, String range) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkChunkExists(this.client.getUrl(), name, digest, range, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>> checkChunkExistsWithResponseAsync(String name, String digest, String range, Context context) {
        String accept = "application/json";
        return this.service.checkChunkExists(this.client.getUrl(), name, digest, range, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkChunkExistsAsync(String name, String digest, String range) {
        return this.checkChunkExistsWithResponseAsync(name, digest, range).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkChunkExistsAsync(String name, String digest, String range, Context context) {
        return this.checkChunkExistsWithResponseAsync(name, digest, range, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void> checkChunkExistsWithResponse(String name, String digest, String range, Context context) {
        String accept = "application/json";
        return this.service.checkChunkExistsSync(this.client.getUrl(), name, digest, range, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkChunkExists(String name, String digest, String range) {
        this.checkChunkExistsWithResponse(name, digest, range, Context.NONE);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureContainerRegist")
    public static interface ContainerRegistryBlobsService {
        @Get(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200, 307})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlob(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200, 307})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData> getBlobSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Head(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200, 307})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>> checkBlobExists(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Head(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200, 307})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void> checkBlobExistsSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlob(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, Context var4);

        @Delete(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void> deleteBlobSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, Context var4);

        @Post(value="/v2/{name}/blobs/uploads/")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlob(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="from") String var3, @QueryParam(value="mount") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/v2/{name}/blobs/uploads/")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void> mountBlobSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="from") String var3, @QueryParam(value="mount") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>> getUploadStatus(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void> getUploadStatusSync(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunk(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunk(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @BodyParam(value="application/octet-stream") BinaryData var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void> uploadChunkSync(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @BodyParam(value="application/octet-stream") BinaryData var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUpload(@HostParam(value="url") String var1, @QueryParam(value="digest") String var2, @PathParam(value="nextBlobUuidLink", encoded=true) String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @HeaderParam(value="Content-Length") Long var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUpload(@HostParam(value="url") String var1, @QueryParam(value="digest") String var2, @PathParam(value="nextBlobUuidLink", encoded=true) String var3, @BodyParam(value="application/octet-stream") BinaryData var4, @HeaderParam(value="Content-Length") Long var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void> completeUploadSync(@HostParam(value="url") String var1, @QueryParam(value="digest") String var2, @PathParam(value="nextBlobUuidLink", encoded=true) String var3, @BodyParam(value="application/octet-stream") BinaryData var4, @HeaderParam(value="Content-Length") Long var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<Void>> cancelUpload(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Delete(value="/{nextBlobUuidLink}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<Void> cancelUploadSync(@HostParam(value="url") String var1, @PathParam(value="nextBlobUuidLink", encoded=true) String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/v2/{name}/blobs/uploads/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>> startUpload(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/v2/{name}/blobs/uploads/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void> startUploadSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={206})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunk(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Range") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={206})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> getChunkSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Range") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Head(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>> checkChunkExists(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Range") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Head(value="/v2/{name}/blobs/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void> checkChunkExistsSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @HeaderParam(value="Range") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

