/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.models.AcrAccessToken;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.AcrRefreshToken;
import com.azure.containers.containerregistry.implementation.models.PostContentSchemaGrantType;
import com.azure.containers.containerregistry.implementation.models.TokenGrantType;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class AuthenticationsImpl {
    private final AuthenticationsService service;
    private final AzureContainerRegistryImpl client;

    AuthenticationsImpl(AzureContainerRegistryImpl client) {
        this.service = (AuthenticationsService)RestProxy.create(AuthenticationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AcrRefreshToken>> exchangeAadAccessTokenForAcrRefreshTokenWithResponseAsync(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exchangeAadAccessTokenForAcrRefreshToken(this.client.getUrl(), this.client.getApiVersion(), grantType, serviceParam, tenant, refreshToken, accessToken, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AcrRefreshToken>> exchangeAadAccessTokenForAcrRefreshTokenWithResponseAsync(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken, Context context) {
        String accept = "application/json";
        return this.service.exchangeAadAccessTokenForAcrRefreshToken(this.client.getUrl(), this.client.getApiVersion(), grantType, serviceParam, tenant, refreshToken, accessToken, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AcrRefreshToken> exchangeAadAccessTokenForAcrRefreshTokenAsync(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken) {
        return this.exchangeAadAccessTokenForAcrRefreshTokenWithResponseAsync(grantType, serviceParam, tenant, refreshToken, accessToken).flatMap(res -> Mono.justOrEmpty((Object)((AcrRefreshToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AcrRefreshToken> exchangeAadAccessTokenForAcrRefreshTokenAsync(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken, Context context) {
        return this.exchangeAadAccessTokenForAcrRefreshTokenWithResponseAsync(grantType, serviceParam, tenant, refreshToken, accessToken, context).flatMap(res -> Mono.justOrEmpty((Object)((AcrRefreshToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AcrRefreshToken> exchangeAadAccessTokenForAcrRefreshTokenWithResponse(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken, Context context) {
        String accept = "application/json";
        return this.service.exchangeAadAccessTokenForAcrRefreshTokenSync(this.client.getUrl(), this.client.getApiVersion(), grantType, serviceParam, tenant, refreshToken, accessToken, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AcrRefreshToken exchangeAadAccessTokenForAcrRefreshToken(PostContentSchemaGrantType grantType, String serviceParam, String tenant, String refreshToken, String accessToken) {
        return (AcrRefreshToken)this.exchangeAadAccessTokenForAcrRefreshTokenWithResponse(grantType, serviceParam, tenant, refreshToken, accessToken, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AcrAccessToken>> exchangeAcrRefreshTokenForAcrAccessTokenWithResponseAsync(String serviceParam, String scope, String refreshToken, TokenGrantType grantType) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exchangeAcrRefreshTokenForAcrAccessToken(this.client.getUrl(), this.client.getApiVersion(), serviceParam, scope, refreshToken, grantType, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AcrAccessToken>> exchangeAcrRefreshTokenForAcrAccessTokenWithResponseAsync(String serviceParam, String scope, String refreshToken, TokenGrantType grantType, Context context) {
        String accept = "application/json";
        return this.service.exchangeAcrRefreshTokenForAcrAccessToken(this.client.getUrl(), this.client.getApiVersion(), serviceParam, scope, refreshToken, grantType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AcrAccessToken> exchangeAcrRefreshTokenForAcrAccessTokenAsync(String serviceParam, String scope, String refreshToken, TokenGrantType grantType) {
        return this.exchangeAcrRefreshTokenForAcrAccessTokenWithResponseAsync(serviceParam, scope, refreshToken, grantType).flatMap(res -> Mono.justOrEmpty((Object)((AcrAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AcrAccessToken> exchangeAcrRefreshTokenForAcrAccessTokenAsync(String serviceParam, String scope, String refreshToken, TokenGrantType grantType, Context context) {
        return this.exchangeAcrRefreshTokenForAcrAccessTokenWithResponseAsync(serviceParam, scope, refreshToken, grantType, context).flatMap(res -> Mono.justOrEmpty((Object)((AcrAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AcrAccessToken> exchangeAcrRefreshTokenForAcrAccessTokenWithResponse(String serviceParam, String scope, String refreshToken, TokenGrantType grantType, Context context) {
        String accept = "application/json";
        return this.service.exchangeAcrRefreshTokenForAcrAccessTokenSync(this.client.getUrl(), this.client.getApiVersion(), serviceParam, scope, refreshToken, grantType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AcrAccessToken exchangeAcrRefreshTokenForAcrAccessToken(String serviceParam, String scope, String refreshToken, TokenGrantType grantType) {
        return (AcrAccessToken)this.exchangeAcrRefreshTokenForAcrAccessTokenWithResponse(serviceParam, scope, refreshToken, grantType, Context.NONE).getValue();
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureContainerRegist")
    public static interface AuthenticationsService {
        @Post(value="/oauth2/exchange")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<AcrRefreshToken>> exchangeAadAccessTokenForAcrRefreshToken(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @FormParam(value="grant_type") PostContentSchemaGrantType var3, @FormParam(value="service") String var4, @FormParam(value="tenant") String var5, @FormParam(value="refresh_token") String var6, @FormParam(value="access_token") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/oauth2/exchange")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<AcrRefreshToken> exchangeAadAccessTokenForAcrRefreshTokenSync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @FormParam(value="grant_type") PostContentSchemaGrantType var3, @FormParam(value="service") String var4, @FormParam(value="tenant") String var5, @FormParam(value="refresh_token") String var6, @FormParam(value="access_token") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/oauth2/token")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<AcrAccessToken>> exchangeAcrRefreshTokenForAcrAccessToken(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @FormParam(value="service") String var3, @FormParam(value="scope") String var4, @FormParam(value="refresh_token") String var5, @FormParam(value="grant_type") TokenGrantType var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/oauth2/token")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<AcrAccessToken> exchangeAcrRefreshTokenForAcrAccessTokenSync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @FormParam(value="service") String var3, @FormParam(value="scope") String var4, @FormParam(value="refresh_token") String var5, @FormParam(value="grant_type") TokenGrantType var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

