/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.RegistryArtifactAsync;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.RepositoryWriteableProperties;
import com.azure.containers.containerregistry.models.ArtifactManifestOrder;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.containers.containerregistry.models.ContainerRepositoryProperties;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerRegistryClientBuilder.class, isAsync=true)
public final class ContainerRepositoryAsync {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRepositoryAsync.class);
    private final ContainerRegistriesImpl serviceClient;
    private final String repositoryName;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final String registryLoginServer;

    ContainerRepositoryAsync(String repositoryName, HttpPipeline httpPipeline, String endpoint, String version) {
        Objects.requireNonNull(repositoryName, "'repositoryName' cannot be null");
        if (repositoryName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'repositoryName' can't be empty."));
        }
        this.endpoint = endpoint;
        this.repositoryName = repositoryName;
        this.serviceClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.apiVersion = version;
        this.httpPipeline = httpPipeline;
        try {
            URL endpointUrl = new URL(endpoint);
            this.registryLoginServer = endpointUrl.getHost();
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
    }

    public String getName() {
        return this.repositoryName;
    }

    public String getRegistryEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        return FluxUtil.withContext(context -> this.deleteWithResponse((Context)context));
    }

    private Mono<Response<Void>> deleteWithResponse(Context context) {
        return this.serviceClient.deleteRepositoryWithResponseAsync(this.repositoryName, context).map(UtilsImpl::deleteResponseToSuccess).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse().flatMap(FluxUtil::toMono);
    }

    public RegistryArtifactAsync getArtifact(String tagOrDigest) {
        return new RegistryArtifactAsync(this.repositoryName, tagOrDigest, this.httpPipeline, this.endpoint, this.apiVersion);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ArtifactManifestProperties> listManifestProperties() {
        return this.listManifestProperties(ArtifactManifestOrder.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ArtifactManifestProperties> listManifestProperties(ArtifactManifestOrder order) {
        return new PagedFlux(pageSize -> FluxUtil.withContext(context -> this.listManifestPropertiesSinglePageAsync((Integer)pageSize, order, (Context)context)), (token, pageSize) -> FluxUtil.withContext(context -> this.listManifestPropertiesNextSinglePageAsync((String)token, (Context)context)));
    }

    private Mono<PagedResponse<ArtifactManifestProperties>> listManifestPropertiesSinglePageAsync(Integer pageSize, ArtifactManifestOrder order, Context context) {
        if (pageSize != null && pageSize < 0) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        String orderString = order == ArtifactManifestOrder.NONE ? null : order.toString();
        return this.serviceClient.getManifestsSinglePageAsync(this.repositoryName, null, pageSize, orderString, context).map(res -> UtilsImpl.getPagedResponseWithContinuationToken(res, baseArtifacts -> UtilsImpl.mapManifestsProperties(baseArtifacts, this.repositoryName, this.registryLoginServer))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<PagedResponse<ArtifactManifestProperties>> listManifestPropertiesNextSinglePageAsync(String nextLink, Context context) {
        return this.serviceClient.getManifestsNextSinglePageAsync(nextLink, context).map(res -> UtilsImpl.getPagedResponseWithContinuationToken(res, baseArtifacts -> UtilsImpl.mapManifestsProperties(baseArtifacts, this.repositoryName, this.registryLoginServer))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponse() {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponse((Context)context));
    }

    private Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponse(Context context) {
        return this.serviceClient.getPropertiesWithResponseAsync(this.repositoryName, context).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponse(ContainerRepositoryProperties repositoryProperties) {
        return FluxUtil.withContext(context -> this.updatePropertiesWithResponse(repositoryProperties, (Context)context));
    }

    private Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponse(ContainerRepositoryProperties repositoryProperties, Context context) {
        if (repositoryProperties == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'value' cannot be null."));
        }
        RepositoryWriteableProperties writableProperties = new RepositoryWriteableProperties().setDeleteEnabled(repositoryProperties.isDeleteEnabled()).setListEnabled(repositoryProperties.isListEnabled()).setWriteEnabled(repositoryProperties.isWriteEnabled()).setReadEnabled(repositoryProperties.isReadEnabled());
        return this.serviceClient.updatePropertiesWithResponseAsync(this.repositoryName, writableProperties, context).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> updateProperties(ContainerRepositoryProperties repositoryProperties) {
        return this.updatePropertiesWithResponse(repositoryProperties).flatMap(FluxUtil::toMono);
    }
}

