/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.RegistryArtifact;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.DeleteRepositoryResult;
import com.azure.containers.containerregistry.implementation.models.ManifestAttributesBase;
import com.azure.containers.containerregistry.implementation.models.RepositoryWriteableProperties;
import com.azure.containers.containerregistry.models.ArtifactManifestOrder;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.containers.containerregistry.models.ContainerRepositoryProperties;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

@ServiceClient(builder=ContainerRegistryClientBuilder.class)
public final class ContainerRepository {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRepository.class);
    private final ContainerRegistriesImpl serviceClient;
    private final String repositoryName;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final String registryLoginServer;

    ContainerRepository(String repositoryName, HttpPipeline httpPipeline, String endpoint, String version) {
        Objects.requireNonNull(repositoryName, "'repositoryName' cannot be null");
        if (repositoryName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'repositoryName' can't be empty."));
        }
        this.endpoint = endpoint;
        this.repositoryName = repositoryName;
        this.serviceClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.apiVersion = version;
        this.httpPipeline = httpPipeline;
        try {
            URL endpointUrl = new URL(endpoint);
            this.registryLoginServer = endpointUrl.getHost();
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
    }

    public String getName() {
        return this.repositoryName;
    }

    public String getRegistryEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Context context) {
        try {
            Response<DeleteRepositoryResult> response = this.serviceClient.deleteRepositoryWithResponse(this.repositoryName, context);
            return UtilsImpl.deleteResponseToSuccess(response);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> getPropertiesWithResponse(Context context) {
        try {
            return this.serviceClient.getPropertiesWithResponse(this.repositoryName, context);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerRepositoryProperties getProperties() {
        return (ContainerRepositoryProperties)this.getPropertiesWithResponse(Context.NONE).getValue();
    }

    public RegistryArtifact getArtifact(String tagOrDigest) {
        return new RegistryArtifact(this.repositoryName, tagOrDigest, this.httpPipeline, this.endpoint, this.apiVersion);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactManifestProperties> listManifestProperties() {
        return this.listManifestProperties(ArtifactManifestOrder.NONE, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactManifestProperties> listManifestProperties(ArtifactManifestOrder order) {
        return this.listManifestProperties(order, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactManifestProperties> listManifestProperties(ArtifactManifestOrder order, Context context) {
        return this.listManifestPropertiesSync(order, context);
    }

    private PagedIterable<ArtifactManifestProperties> listManifestPropertiesSync(ArtifactManifestOrder order, Context context) {
        return new PagedIterable(pageSize -> this.listManifestPropertiesSinglePageSync((Integer)pageSize, order, context), (token, pageSize) -> this.listManifestPropertiesNextSinglePageSync((String)token, context));
    }

    private PagedResponse<ArtifactManifestProperties> listManifestPropertiesSinglePageSync(Integer pageSize, ArtifactManifestOrder order, Context context) {
        if (pageSize != null && pageSize < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        String orderString = order == ArtifactManifestOrder.NONE ? null : order.toString();
        try {
            PagedResponse<ManifestAttributesBase> res = this.serviceClient.getManifestsSinglePage(this.repositoryName, null, pageSize, orderString, context);
            return UtilsImpl.getPagedResponseWithContinuationToken(res, baseArtifacts -> UtilsImpl.mapManifestsProperties(baseArtifacts, this.repositoryName, this.registryLoginServer));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }

    private PagedResponse<ArtifactManifestProperties> listManifestPropertiesNextSinglePageSync(String nextLink, Context context) {
        try {
            PagedResponse<ManifestAttributesBase> res = this.serviceClient.getManifestsNextSinglePage(nextLink, context);
            return UtilsImpl.getPagedResponseWithContinuationToken(res, baseArtifacts -> UtilsImpl.mapManifestsProperties(baseArtifacts, this.repositoryName, this.registryLoginServer));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> updatePropertiesWithResponse(ContainerRepositoryProperties repositoryProperties, Context context) {
        return this.updatePropertiesWithResponseSync(repositoryProperties, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerRepositoryProperties updateProperties(ContainerRepositoryProperties repositoryProperties) {
        return (ContainerRepositoryProperties)this.updatePropertiesWithResponse(repositoryProperties, Context.NONE).getValue();
    }

    private Response<ContainerRepositoryProperties> updatePropertiesWithResponseSync(ContainerRepositoryProperties repositoryProperties, Context context) {
        Objects.requireNonNull(repositoryProperties, "'repositoryProperties' cannot be null");
        RepositoryWriteableProperties writableProperties = new RepositoryWriteableProperties().setDeleteEnabled(repositoryProperties.isDeleteEnabled()).setListEnabled(repositoryProperties.isListEnabled()).setWriteEnabled(repositoryProperties.isWriteEnabled()).setReadEnabled(repositoryProperties.isReadEnabled());
        try {
            return this.serviceClient.updatePropertiesWithResponse(this.repositoryName, writableProperties, context);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }
}

