/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchContainerConfiguration;
import com.azure.compute.batch.models.BatchNodePlacementConfiguration;
import com.azure.compute.batch.models.BatchOsDisk;
import com.azure.compute.batch.models.BatchVmImageReference;
import com.azure.compute.batch.models.DataDisk;
import com.azure.compute.batch.models.DiskEncryptionConfiguration;
import com.azure.compute.batch.models.SecurityProfile;
import com.azure.compute.batch.models.ServiceArtifactReference;
import com.azure.compute.batch.models.VMExtension;
import com.azure.compute.batch.models.WindowsConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineConfiguration
implements JsonSerializable<VirtualMachineConfiguration> {
    private final BatchVmImageReference imageReference;
    private final String nodeAgentSkuId;
    private WindowsConfiguration windowsConfiguration;
    private List<DataDisk> dataDisks;
    private String licenseType;
    private BatchContainerConfiguration containerConfiguration;
    private DiskEncryptionConfiguration diskEncryptionConfiguration;
    private BatchNodePlacementConfiguration nodePlacementConfiguration;
    private List<VMExtension> extensions;
    private BatchOsDisk osDisk;
    private SecurityProfile securityProfile;
    private ServiceArtifactReference serviceArtifactReference;

    public BatchVmImageReference getImageReference() {
        return this.imageReference;
    }

    public String getNodeAgentSkuId() {
        return this.nodeAgentSkuId;
    }

    public WindowsConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    public VirtualMachineConfiguration setWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public List<DataDisk> getDataDisks() {
        return this.dataDisks;
    }

    public VirtualMachineConfiguration setDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public VirtualMachineConfiguration setLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public BatchContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public DiskEncryptionConfiguration getDiskEncryptionConfiguration() {
        return this.diskEncryptionConfiguration;
    }

    public VirtualMachineConfiguration setDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
        this.diskEncryptionConfiguration = diskEncryptionConfiguration;
        return this;
    }

    public BatchNodePlacementConfiguration getNodePlacementConfiguration() {
        return this.nodePlacementConfiguration;
    }

    public VirtualMachineConfiguration setNodePlacementConfiguration(BatchNodePlacementConfiguration nodePlacementConfiguration) {
        this.nodePlacementConfiguration = nodePlacementConfiguration;
        return this;
    }

    public List<VMExtension> getExtensions() {
        return this.extensions;
    }

    public VirtualMachineConfiguration setExtensions(List<VMExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public BatchOsDisk getOsDisk() {
        return this.osDisk;
    }

    public SecurityProfile getSecurityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineConfiguration setSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public ServiceArtifactReference getServiceArtifactReference() {
        return this.serviceArtifactReference;
    }

    public VirtualMachineConfiguration setServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeStringField("nodeAgentSKUId", this.nodeAgentSkuId);
        jsonWriter.writeJsonField("windowsConfiguration", (JsonSerializable)this.windowsConfiguration);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeJsonField("containerConfiguration", (JsonSerializable)this.containerConfiguration);
        jsonWriter.writeJsonField("diskEncryptionConfiguration", (JsonSerializable)this.diskEncryptionConfiguration);
        jsonWriter.writeJsonField("nodePlacementConfiguration", (JsonSerializable)this.nodePlacementConfiguration);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("serviceArtifactReference", (JsonSerializable)this.serviceArtifactReference);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineConfiguration)jsonReader.readObject(reader -> {
            BatchVmImageReference imageReference = null;
            String nodeAgentSkuId = null;
            WindowsConfiguration windowsConfiguration = null;
            List dataDisks = null;
            String licenseType = null;
            BatchContainerConfiguration containerConfiguration = null;
            DiskEncryptionConfiguration diskEncryptionConfiguration = null;
            BatchNodePlacementConfiguration nodePlacementConfiguration = null;
            List extensions = null;
            BatchOsDisk osDisk = null;
            SecurityProfile securityProfile = null;
            ServiceArtifactReference serviceArtifactReference = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    imageReference = BatchVmImageReference.fromJson(reader);
                    continue;
                }
                if ("nodeAgentSKUId".equals(fieldName)) {
                    nodeAgentSkuId = reader.getString();
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    windowsConfiguration = WindowsConfiguration.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    dataDisks = reader.readArray(reader1 -> DataDisk.fromJson(reader1));
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    licenseType = reader.getString();
                    continue;
                }
                if ("containerConfiguration".equals(fieldName)) {
                    containerConfiguration = BatchContainerConfiguration.fromJson(reader);
                    continue;
                }
                if ("diskEncryptionConfiguration".equals(fieldName)) {
                    diskEncryptionConfiguration = DiskEncryptionConfiguration.fromJson(reader);
                    continue;
                }
                if ("nodePlacementConfiguration".equals(fieldName)) {
                    nodePlacementConfiguration = BatchNodePlacementConfiguration.fromJson(reader);
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    extensions = reader.readArray(reader1 -> VMExtension.fromJson(reader1));
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    osDisk = BatchOsDisk.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("serviceArtifactReference".equals(fieldName)) {
                    serviceArtifactReference = ServiceArtifactReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            VirtualMachineConfiguration deserializedVirtualMachineConfiguration = new VirtualMachineConfiguration(imageReference, nodeAgentSkuId);
            deserializedVirtualMachineConfiguration.windowsConfiguration = windowsConfiguration;
            deserializedVirtualMachineConfiguration.dataDisks = dataDisks;
            deserializedVirtualMachineConfiguration.licenseType = licenseType;
            deserializedVirtualMachineConfiguration.containerConfiguration = containerConfiguration;
            deserializedVirtualMachineConfiguration.diskEncryptionConfiguration = diskEncryptionConfiguration;
            deserializedVirtualMachineConfiguration.nodePlacementConfiguration = nodePlacementConfiguration;
            deserializedVirtualMachineConfiguration.extensions = extensions;
            deserializedVirtualMachineConfiguration.osDisk = osDisk;
            deserializedVirtualMachineConfiguration.securityProfile = securityProfile;
            deserializedVirtualMachineConfiguration.serviceArtifactReference = serviceArtifactReference;
            return deserializedVirtualMachineConfiguration;
        });
    }

    public VirtualMachineConfiguration setContainerConfiguration(BatchContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public VirtualMachineConfiguration(BatchVmImageReference imageReference, String nodeAgentSkuId) {
        this.imageReference = imageReference;
        this.nodeAgentSkuId = nodeAgentSkuId;
    }

    public VirtualMachineConfiguration setOsDisk(BatchOsDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }
}

