/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchUefiSettings;
import com.azure.compute.batch.models.SecurityTypes;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SecurityProfile
implements JsonSerializable<SecurityProfile> {
    private Boolean encryptionAtHost;
    private SecurityTypes securityType;
    private BatchUefiSettings uefiSettings;

    public Boolean isEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    public SecurityTypes getSecurityType() {
        return this.securityType;
    }

    public BatchUefiSettings getUefiSettings() {
        return this.uefiSettings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("encryptionAtHost", this.encryptionAtHost);
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        jsonWriter.writeJsonField("uefiSettings", (JsonSerializable)this.uefiSettings);
        return jsonWriter.writeEndObject();
    }

    public static SecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityProfile)jsonReader.readObject(reader -> {
            SecurityProfile deserializedSecurityProfile = new SecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encryptionAtHost".equals(fieldName)) {
                    deserializedSecurityProfile.encryptionAtHost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityType".equals(fieldName)) {
                    deserializedSecurityProfile.securityType = SecurityTypes.fromString(reader.getString());
                    continue;
                }
                if ("uefiSettings".equals(fieldName)) {
                    deserializedSecurityProfile.uefiSettings = BatchUefiSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityProfile;
        });
    }

    public SecurityProfile setEncryptionAtHost(Boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
        return this;
    }

    public SecurityProfile setSecurityType(SecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    public SecurityProfile setUefiSettings(BatchUefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }
}

