/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class RollingUpgradePolicy
implements JsonSerializable<RollingUpgradePolicy> {
    private Boolean enableCrossZoneUpgrade;
    private Integer maxBatchInstancePercent;
    private Integer maxUnhealthyInstancePercent;
    private Integer maxUnhealthyUpgradedInstancePercent;
    private Duration pauseTimeBetweenBatches;
    private Boolean prioritizeUnhealthyInstances;
    private Boolean rollbackFailedInstancesOnPolicyBreach;

    public Boolean isEnableCrossZoneUpgrade() {
        return this.enableCrossZoneUpgrade;
    }

    public RollingUpgradePolicy setEnableCrossZoneUpgrade(Boolean enableCrossZoneUpgrade) {
        this.enableCrossZoneUpgrade = enableCrossZoneUpgrade;
        return this;
    }

    public Integer getMaxBatchInstancePercent() {
        return this.maxBatchInstancePercent;
    }

    public RollingUpgradePolicy setMaxBatchInstancePercent(Integer maxBatchInstancePercent) {
        this.maxBatchInstancePercent = maxBatchInstancePercent;
        return this;
    }

    public Integer getMaxUnhealthyInstancePercent() {
        return this.maxUnhealthyInstancePercent;
    }

    public RollingUpgradePolicy setMaxUnhealthyInstancePercent(Integer maxUnhealthyInstancePercent) {
        this.maxUnhealthyInstancePercent = maxUnhealthyInstancePercent;
        return this;
    }

    public Integer getMaxUnhealthyUpgradedInstancePercent() {
        return this.maxUnhealthyUpgradedInstancePercent;
    }

    public RollingUpgradePolicy setMaxUnhealthyUpgradedInstancePercent(Integer maxUnhealthyUpgradedInstancePercent) {
        this.maxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent;
        return this;
    }

    public Duration getPauseTimeBetweenBatches() {
        return this.pauseTimeBetweenBatches;
    }

    public RollingUpgradePolicy setPauseTimeBetweenBatches(Duration pauseTimeBetweenBatches) {
        this.pauseTimeBetweenBatches = pauseTimeBetweenBatches;
        return this;
    }

    public Boolean isPrioritizeUnhealthyInstances() {
        return this.prioritizeUnhealthyInstances;
    }

    public RollingUpgradePolicy setPrioritizeUnhealthyInstances(Boolean prioritizeUnhealthyInstances) {
        this.prioritizeUnhealthyInstances = prioritizeUnhealthyInstances;
        return this;
    }

    public Boolean isRollbackFailedInstancesOnPolicyBreach() {
        return this.rollbackFailedInstancesOnPolicyBreach;
    }

    public RollingUpgradePolicy setRollbackFailedInstancesOnPolicyBreach(Boolean rollbackFailedInstancesOnPolicyBreach) {
        this.rollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableCrossZoneUpgrade", this.enableCrossZoneUpgrade);
        jsonWriter.writeNumberField("maxBatchInstancePercent", (Number)this.maxBatchInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyInstancePercent", (Number)this.maxUnhealthyInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyUpgradedInstancePercent", (Number)this.maxUnhealthyUpgradedInstancePercent);
        jsonWriter.writeStringField("pauseTimeBetweenBatches", CoreUtils.durationToStringWithDays((Duration)this.pauseTimeBetweenBatches));
        jsonWriter.writeBooleanField("prioritizeUnhealthyInstances", this.prioritizeUnhealthyInstances);
        jsonWriter.writeBooleanField("rollbackFailedInstancesOnPolicyBreach", this.rollbackFailedInstancesOnPolicyBreach);
        return jsonWriter.writeEndObject();
    }

    public static RollingUpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RollingUpgradePolicy)jsonReader.readObject(reader -> {
            RollingUpgradePolicy deserializedRollingUpgradePolicy = new RollingUpgradePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableCrossZoneUpgrade".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.enableCrossZoneUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxBatchInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxBatchInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxUnhealthyInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxUnhealthyUpgradedInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyUpgradedInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("pauseTimeBetweenBatches".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.pauseTimeBetweenBatches = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("prioritizeUnhealthyInstances".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.prioritizeUnhealthyInstances = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rollbackFailedInstancesOnPolicyBreach".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.rollbackFailedInstancesOnPolicyBreach = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRollingUpgradePolicy;
        });
    }
}

