/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeIdentityReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceFile
implements JsonSerializable<ResourceFile> {
    private String autoStorageContainerName;
    private String storageContainerUrl;
    private String httpUrl;
    private String blobPrefix;
    private String filePath;
    private String fileMode;
    private BatchNodeIdentityReference identityReference;

    public String getAutoStorageContainerName() {
        return this.autoStorageContainerName;
    }

    public ResourceFile setAutoStorageContainerName(String autoStorageContainerName) {
        this.autoStorageContainerName = autoStorageContainerName;
        return this;
    }

    public String getStorageContainerUrl() {
        return this.storageContainerUrl;
    }

    public ResourceFile setStorageContainerUrl(String storageContainerUrl) {
        this.storageContainerUrl = storageContainerUrl;
        return this;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public ResourceFile setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
        return this;
    }

    public String getBlobPrefix() {
        return this.blobPrefix;
    }

    public ResourceFile setBlobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public ResourceFile setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public ResourceFile setFileMode(String fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    public BatchNodeIdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public ResourceFile setIdentityReference(BatchNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoStorageContainerName", this.autoStorageContainerName);
        jsonWriter.writeStringField("storageContainerUrl", this.storageContainerUrl);
        jsonWriter.writeStringField("httpUrl", this.httpUrl);
        jsonWriter.writeStringField("blobPrefix", this.blobPrefix);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("fileMode", this.fileMode);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static ResourceFile fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceFile)jsonReader.readObject(reader -> {
            ResourceFile deserializedResourceFile = new ResourceFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoStorageContainerName".equals(fieldName)) {
                    deserializedResourceFile.autoStorageContainerName = reader.getString();
                    continue;
                }
                if ("storageContainerUrl".equals(fieldName)) {
                    deserializedResourceFile.storageContainerUrl = reader.getString();
                    continue;
                }
                if ("httpUrl".equals(fieldName)) {
                    deserializedResourceFile.httpUrl = reader.getString();
                    continue;
                }
                if ("blobPrefix".equals(fieldName)) {
                    deserializedResourceFile.blobPrefix = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedResourceFile.filePath = reader.getString();
                    continue;
                }
                if ("fileMode".equals(fieldName)) {
                    deserializedResourceFile.fileMode = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    deserializedResourceFile.identityReference = BatchNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceFile;
        });
    }
}

