/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.NetworkSecurityGroupRuleAccess;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupRule
implements JsonSerializable<NetworkSecurityGroupRule> {
    private final int priority;
    private final NetworkSecurityGroupRuleAccess access;
    private final String sourceAddressPrefix;
    private List<String> sourcePortRanges;

    public NetworkSecurityGroupRule(int priority, NetworkSecurityGroupRuleAccess access, String sourceAddressPrefix) {
        this.priority = priority;
        this.access = access;
        this.sourceAddressPrefix = sourceAddressPrefix;
    }

    public int getPriority() {
        return this.priority;
    }

    public NetworkSecurityGroupRuleAccess getAccess() {
        return this.access;
    }

    public String getSourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public List<String> getSourcePortRanges() {
        return this.sourcePortRanges;
    }

    public NetworkSecurityGroupRule setSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeStringField("sourceAddressPrefix", this.sourceAddressPrefix);
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupRule fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupRule)jsonReader.readObject(reader -> {
            int priority = 0;
            NetworkSecurityGroupRuleAccess access = null;
            String sourceAddressPrefix = null;
            List sourcePortRanges = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    priority = reader.getInt();
                    continue;
                }
                if ("access".equals(fieldName)) {
                    access = NetworkSecurityGroupRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("sourceAddressPrefix".equals(fieldName)) {
                    sourceAddressPrefix = reader.getString();
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            NetworkSecurityGroupRule deserializedNetworkSecurityGroupRule = new NetworkSecurityGroupRule(priority, access, sourceAddressPrefix);
            deserializedNetworkSecurityGroupRule.sourcePortRanges = sourcePortRanges;
            return deserializedNetworkSecurityGroupRule;
        });
    }
}

