/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchError;
import com.azure.compute.batch.models.BatchTaskAddStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchTaskCreateResult
implements JsonSerializable<BatchTaskCreateResult> {
    private final BatchTaskAddStatus status;
    private final String taskId;
    private String eTag;
    private OffsetDateTime lastModified;
    private String location;
    private BatchError error;

    private BatchTaskCreateResult(BatchTaskAddStatus status, String taskId) {
        this.status = status;
        this.taskId = taskId;
    }

    public BatchTaskAddStatus getStatus() {
        return this.status;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public BatchError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeStringField("eTag", this.eTag);
        jsonWriter.writeStringField("lastModified", this.lastModified == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModified));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskCreateResult fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskCreateResult)jsonReader.readObject(reader -> {
            BatchTaskAddStatus status = null;
            String taskId = null;
            String eTag = null;
            OffsetDateTime lastModified = null;
            String location = null;
            BatchError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = BatchTaskAddStatus.fromString(reader.getString());
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    taskId = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("location".equals(fieldName)) {
                    location = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = BatchError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchTaskCreateResult deserializedBatchTaskCreateResult = new BatchTaskCreateResult(status, taskId);
            deserializedBatchTaskCreateResult.eTag = eTag;
            deserializedBatchTaskCreateResult.lastModified = lastModified;
            deserializedBatchTaskCreateResult.location = location;
            deserializedBatchTaskCreateResult.error = error;
            return deserializedBatchTaskCreateResult;
        });
    }
}

