/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class BatchTaskConstraints
implements JsonSerializable<BatchTaskConstraints> {
    private Duration maxWallClockTime;
    private Duration retentionTime;
    private Integer maxTaskRetryCount;

    public Duration getMaxWallClockTime() {
        return this.maxWallClockTime;
    }

    public BatchTaskConstraints setMaxWallClockTime(Duration maxWallClockTime) {
        this.maxWallClockTime = maxWallClockTime;
        return this;
    }

    public Duration getRetentionTime() {
        return this.retentionTime;
    }

    public BatchTaskConstraints setRetentionTime(Duration retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public Integer getMaxTaskRetryCount() {
        return this.maxTaskRetryCount;
    }

    public BatchTaskConstraints setMaxTaskRetryCount(Integer maxTaskRetryCount) {
        this.maxTaskRetryCount = maxTaskRetryCount;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxWallClockTime", CoreUtils.durationToStringWithDays((Duration)this.maxWallClockTime));
        jsonWriter.writeStringField("retentionTime", CoreUtils.durationToStringWithDays((Duration)this.retentionTime));
        jsonWriter.writeNumberField("maxTaskRetryCount", (Number)this.maxTaskRetryCount);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskConstraints fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskConstraints)jsonReader.readObject(reader -> {
            BatchTaskConstraints deserializedBatchTaskConstraints = new BatchTaskConstraints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxWallClockTime".equals(fieldName)) {
                    deserializedBatchTaskConstraints.maxWallClockTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("retentionTime".equals(fieldName)) {
                    deserializedBatchTaskConstraints.retentionTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxTaskRetryCount".equals(fieldName)) {
                    deserializedBatchTaskConstraints.maxTaskRetryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchTaskConstraints;
        });
    }
}

