/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class BatchPoolResourceStatistics
implements JsonSerializable<BatchPoolResourceStatistics> {
    private final OffsetDateTime startTime;
    private final OffsetDateTime lastUpdateTime;
    private final double avgCpuPercentage;
    private final double avgMemoryGiB;
    private final double peakMemoryGiB;
    private final double avgDiskGiB;
    private final double peakDiskGiB;
    private final double diskReadGiB;
    private final double diskWriteGiB;
    private final double networkReadGiB;
    private final double networkWriteGiB;
    private final long diskReadIops;
    private final long diskWriteIops;

    private BatchPoolResourceStatistics(OffsetDateTime startTime, OffsetDateTime lastUpdateTime, double avgCpuPercentage, double avgMemoryGiB, double peakMemoryGiB, double avgDiskGiB, double peakDiskGiB, long diskReadIops, long diskWriteIops, double diskReadGiB, double diskWriteGiB, double networkReadGiB, double networkWriteGiB) {
        this.startTime = startTime;
        this.lastUpdateTime = lastUpdateTime;
        this.avgCpuPercentage = avgCpuPercentage;
        this.avgMemoryGiB = avgMemoryGiB;
        this.peakMemoryGiB = peakMemoryGiB;
        this.avgDiskGiB = avgDiskGiB;
        this.peakDiskGiB = peakDiskGiB;
        this.diskReadIops = diskReadIops;
        this.diskWriteIops = diskWriteIops;
        this.diskReadGiB = diskReadGiB;
        this.diskWriteGiB = diskWriteGiB;
        this.networkReadGiB = networkReadGiB;
        this.networkWriteGiB = networkWriteGiB;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public double getAvgCpuPercentage() {
        return this.avgCpuPercentage;
    }

    public double getAvgMemoryGiB() {
        return this.avgMemoryGiB;
    }

    public double getPeakMemoryGiB() {
        return this.peakMemoryGiB;
    }

    public double getAvgDiskGiB() {
        return this.avgDiskGiB;
    }

    public double getPeakDiskGiB() {
        return this.peakDiskGiB;
    }

    public double getDiskReadGiB() {
        return this.diskReadGiB;
    }

    public double getDiskWriteGiB() {
        return this.diskWriteGiB;
    }

    public double getNetworkReadGiB() {
        return this.networkReadGiB;
    }

    public double getNetworkWriteGiB() {
        return this.networkWriteGiB;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        jsonWriter.writeDoubleField("avgCPUPercentage", this.avgCpuPercentage);
        jsonWriter.writeDoubleField("avgMemoryGiB", this.avgMemoryGiB);
        jsonWriter.writeDoubleField("peakMemoryGiB", this.peakMemoryGiB);
        jsonWriter.writeDoubleField("avgDiskGiB", this.avgDiskGiB);
        jsonWriter.writeDoubleField("peakDiskGiB", this.peakDiskGiB);
        jsonWriter.writeStringField("diskReadIOps", Objects.toString(this.diskReadIops, null));
        jsonWriter.writeStringField("diskWriteIOps", Objects.toString(this.diskWriteIops, null));
        jsonWriter.writeDoubleField("diskReadGiB", this.diskReadGiB);
        jsonWriter.writeDoubleField("diskWriteGiB", this.diskWriteGiB);
        jsonWriter.writeDoubleField("networkReadGiB", this.networkReadGiB);
        jsonWriter.writeDoubleField("networkWriteGiB", this.networkWriteGiB);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolResourceStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolResourceStatistics)jsonReader.readObject(reader -> {
            OffsetDateTime startTime = null;
            OffsetDateTime lastUpdateTime = null;
            double avgCpuPercentage = 0.0;
            double avgMemoryGiB = 0.0;
            double peakMemoryGiB = 0.0;
            double avgDiskGiB = 0.0;
            double peakDiskGiB = 0.0;
            long diskReadIops = Long.parseLong("0");
            long diskWriteIops = Long.parseLong("0");
            double diskReadGiB = 0.0;
            double diskWriteGiB = 0.0;
            double networkReadGiB = 0.0;
            double networkWriteGiB = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("avgCPUPercentage".equals(fieldName)) {
                    avgCpuPercentage = reader.getDouble();
                    continue;
                }
                if ("avgMemoryGiB".equals(fieldName)) {
                    avgMemoryGiB = reader.getDouble();
                    continue;
                }
                if ("peakMemoryGiB".equals(fieldName)) {
                    peakMemoryGiB = reader.getDouble();
                    continue;
                }
                if ("avgDiskGiB".equals(fieldName)) {
                    avgDiskGiB = reader.getDouble();
                    continue;
                }
                if ("peakDiskGiB".equals(fieldName)) {
                    peakDiskGiB = reader.getDouble();
                    continue;
                }
                if ("diskReadIOps".equals(fieldName)) {
                    diskReadIops = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("diskWriteIOps".equals(fieldName)) {
                    diskWriteIops = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("diskReadGiB".equals(fieldName)) {
                    diskReadGiB = reader.getDouble();
                    continue;
                }
                if ("diskWriteGiB".equals(fieldName)) {
                    diskWriteGiB = reader.getDouble();
                    continue;
                }
                if ("networkReadGiB".equals(fieldName)) {
                    networkReadGiB = reader.getDouble();
                    continue;
                }
                if ("networkWriteGiB".equals(fieldName)) {
                    networkWriteGiB = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchPoolResourceStatistics(startTime, lastUpdateTime, avgCpuPercentage, avgMemoryGiB, peakMemoryGiB, avgDiskGiB, peakDiskGiB, diskReadIops, diskWriteIops, diskReadGiB, diskWriteGiB, networkReadGiB, networkWriteGiB);
        });
    }

    public long getDiskReadIops() {
        return this.diskReadIops;
    }

    public long getDiskWriteIops() {
        return this.diskWriteIops;
    }
}

