/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeDeallocationOption;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class BatchPoolResizeParameters
implements JsonSerializable<BatchPoolResizeParameters> {
    private Integer targetDedicatedNodes;
    private Integer targetLowPriorityNodes;
    private Duration resizeTimeout;
    private BatchNodeDeallocationOption nodeDeallocationOption;

    public Integer getTargetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    public BatchPoolResizeParameters setTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    public Integer getTargetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    public BatchPoolResizeParameters setTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    public Duration getResizeTimeout() {
        return this.resizeTimeout;
    }

    public BatchPoolResizeParameters setResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public BatchNodeDeallocationOption getNodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    public BatchPoolResizeParameters setNodeDeallocationOption(BatchNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("targetDedicatedNodes", (Number)this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", (Number)this.targetLowPriorityNodes);
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeStringField("nodeDeallocationOption", this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolResizeParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolResizeParameters)jsonReader.readObject(reader -> {
            BatchPoolResizeParameters deserializedBatchPoolResizeParameters = new BatchPoolResizeParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedBatchPoolResizeParameters.targetDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedBatchPoolResizeParameters.targetLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    deserializedBatchPoolResizeParameters.resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("nodeDeallocationOption".equals(fieldName)) {
                    deserializedBatchPoolResizeParameters.nodeDeallocationOption = BatchNodeDeallocationOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolResizeParameters;
        });
    }
}

