/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class BatchPoolEnableAutoScaleParameters
implements JsonSerializable<BatchPoolEnableAutoScaleParameters> {
    private String autoScaleFormula;
    private Duration autoScaleEvaluationInterval;

    public String getAutoScaleFormula() {
        return this.autoScaleFormula;
    }

    public BatchPoolEnableAutoScaleParameters setAutoScaleFormula(String autoScaleFormula) {
        this.autoScaleFormula = autoScaleFormula;
        return this;
    }

    public Duration getAutoScaleEvaluationInterval() {
        return this.autoScaleEvaluationInterval;
    }

    public BatchPoolEnableAutoScaleParameters setAutoScaleEvaluationInterval(Duration autoScaleEvaluationInterval) {
        this.autoScaleEvaluationInterval = autoScaleEvaluationInterval;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoScaleFormula", this.autoScaleFormula);
        jsonWriter.writeStringField("autoScaleEvaluationInterval", CoreUtils.durationToStringWithDays((Duration)this.autoScaleEvaluationInterval));
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolEnableAutoScaleParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolEnableAutoScaleParameters)jsonReader.readObject(reader -> {
            BatchPoolEnableAutoScaleParameters deserializedBatchPoolEnableAutoScaleParameters = new BatchPoolEnableAutoScaleParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoScaleFormula".equals(fieldName)) {
                    deserializedBatchPoolEnableAutoScaleParameters.autoScaleFormula = reader.getString();
                    continue;
                }
                if ("autoScaleEvaluationInterval".equals(fieldName)) {
                    deserializedBatchPoolEnableAutoScaleParameters.autoScaleEvaluationInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolEnableAutoScaleParameters;
        });
    }
}

