/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchCertificateReference;
import com.azure.compute.batch.models.BatchMetadataItem;
import com.azure.compute.batch.models.BatchNodeCommunicationMode;
import com.azure.compute.batch.models.BatchStartTask;
import com.azure.compute.batch.models.BatchTaskSchedulingPolicy;
import com.azure.compute.batch.models.MountConfiguration;
import com.azure.compute.batch.models.NetworkConfiguration;
import com.azure.compute.batch.models.UpgradePolicy;
import com.azure.compute.batch.models.UserAccount;
import com.azure.compute.batch.models.VirtualMachineConfiguration;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public final class BatchPoolCreateParameters
implements JsonSerializable<BatchPoolCreateParameters> {
    private final String id;
    private String displayName;
    private final String vmSize;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private Duration resizeTimeout;
    private Map<String, String> resourceTags;
    private Integer targetDedicatedNodes;
    private Integer targetLowPriorityNodes;
    private Boolean enableAutoScale;
    private String autoScaleFormula;
    private Duration autoScaleEvaluationInterval;
    private Boolean enableInterNodeCommunication;
    private NetworkConfiguration networkConfiguration;
    private BatchStartTask startTask;
    private List<BatchCertificateReference> certificateReferences;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private Integer taskSlotsPerNode;
    private BatchTaskSchedulingPolicy taskSchedulingPolicy;
    private List<UserAccount> userAccounts;
    private List<BatchMetadataItem> metadata;
    private List<MountConfiguration> mountConfiguration;
    private BatchNodeCommunicationMode targetNodeCommunicationMode;
    private UpgradePolicy upgradePolicy;

    public BatchPoolCreateParameters(String id, String vmSize) {
        this.id = id;
        this.vmSize = vmSize;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchPoolCreateParameters setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public VirtualMachineConfiguration getVirtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public BatchPoolCreateParameters setVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    public Duration getResizeTimeout() {
        return this.resizeTimeout;
    }

    public BatchPoolCreateParameters setResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags;
    }

    public BatchPoolCreateParameters setResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public Integer getTargetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    public BatchPoolCreateParameters setTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    public Integer getTargetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    public BatchPoolCreateParameters setTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    public Boolean isEnableAutoScale() {
        return this.enableAutoScale;
    }

    public BatchPoolCreateParameters setEnableAutoScale(Boolean enableAutoScale) {
        this.enableAutoScale = enableAutoScale;
        return this;
    }

    public String getAutoScaleFormula() {
        return this.autoScaleFormula;
    }

    public BatchPoolCreateParameters setAutoScaleFormula(String autoScaleFormula) {
        this.autoScaleFormula = autoScaleFormula;
        return this;
    }

    public Duration getAutoScaleEvaluationInterval() {
        return this.autoScaleEvaluationInterval;
    }

    public BatchPoolCreateParameters setAutoScaleEvaluationInterval(Duration autoScaleEvaluationInterval) {
        this.autoScaleEvaluationInterval = autoScaleEvaluationInterval;
        return this;
    }

    public Boolean isEnableInterNodeCommunication() {
        return this.enableInterNodeCommunication;
    }

    public BatchPoolCreateParameters setEnableInterNodeCommunication(Boolean enableInterNodeCommunication) {
        this.enableInterNodeCommunication = enableInterNodeCommunication;
        return this;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchPoolCreateParameters setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public BatchStartTask getStartTask() {
        return this.startTask;
    }

    public BatchPoolCreateParameters setStartTask(BatchStartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    public List<BatchCertificateReference> getCertificateReferences() {
        return this.certificateReferences;
    }

    public BatchPoolCreateParameters setCertificateReferences(List<BatchCertificateReference> certificateReferences) {
        this.certificateReferences = certificateReferences;
        return this;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public BatchPoolCreateParameters setApplicationPackageReferences(List<BatchApplicationPackageReference> applicationPackageReferences) {
        this.applicationPackageReferences = applicationPackageReferences;
        return this;
    }

    public Integer getTaskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    public BatchPoolCreateParameters setTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.taskSlotsPerNode = taskSlotsPerNode;
        return this;
    }

    public BatchTaskSchedulingPolicy getTaskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    public BatchPoolCreateParameters setTaskSchedulingPolicy(BatchTaskSchedulingPolicy taskSchedulingPolicy) {
        this.taskSchedulingPolicy = taskSchedulingPolicy;
        return this;
    }

    public List<UserAccount> getUserAccounts() {
        return this.userAccounts;
    }

    public BatchPoolCreateParameters setUserAccounts(List<UserAccount> userAccounts) {
        this.userAccounts = userAccounts;
        return this;
    }

    public List<BatchMetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchPoolCreateParameters setMetadata(List<BatchMetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<MountConfiguration> getMountConfiguration() {
        return this.mountConfiguration;
    }

    public BatchPoolCreateParameters setMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.mountConfiguration = mountConfiguration;
        return this;
    }

    public BatchNodeCommunicationMode getTargetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public BatchPoolCreateParameters setTargetNodeCommunicationMode(BatchNodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    public BatchPoolCreateParameters setUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("virtualMachineConfiguration", (JsonSerializable)this.virtualMachineConfiguration);
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeMapField("resourceTags", this.resourceTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("targetDedicatedNodes", (Number)this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", (Number)this.targetLowPriorityNodes);
        jsonWriter.writeBooleanField("enableAutoScale", this.enableAutoScale);
        jsonWriter.writeStringField("autoScaleFormula", this.autoScaleFormula);
        jsonWriter.writeStringField("autoScaleEvaluationInterval", CoreUtils.durationToStringWithDays((Duration)this.autoScaleEvaluationInterval));
        jsonWriter.writeBooleanField("enableInterNodeCommunication", this.enableInterNodeCommunication);
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeArrayField("certificateReferences", this.certificateReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationPackageReferences", this.applicationPackageReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("taskSlotsPerNode", (Number)this.taskSlotsPerNode);
        jsonWriter.writeJsonField("taskSchedulingPolicy", (JsonSerializable)this.taskSchedulingPolicy);
        jsonWriter.writeArrayField("userAccounts", this.userAccounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("mountConfiguration", this.mountConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("targetNodeCommunicationMode", this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        jsonWriter.writeJsonField("upgradePolicy", (JsonSerializable)this.upgradePolicy);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolCreateParameters)jsonReader.readObject(reader -> {
            String id = null;
            String vmSize = null;
            String displayName = null;
            VirtualMachineConfiguration virtualMachineConfiguration = null;
            Duration resizeTimeout = null;
            Map resourceTags = null;
            Integer targetDedicatedNodes = null;
            Integer targetLowPriorityNodes = null;
            Boolean enableAutoScale = null;
            String autoScaleFormula = null;
            Duration autoScaleEvaluationInterval = null;
            Boolean enableInterNodeCommunication = null;
            NetworkConfiguration networkConfiguration = null;
            BatchStartTask startTask = null;
            List certificateReferences = null;
            List applicationPackageReferences = null;
            Integer taskSlotsPerNode = null;
            BatchTaskSchedulingPolicy taskSchedulingPolicy = null;
            List userAccounts = null;
            List metadata = null;
            List mountConfiguration = null;
            BatchNodeCommunicationMode targetNodeCommunicationMode = null;
            UpgradePolicy upgradePolicy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    vmSize = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    resourceTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("targetDedicatedNodes".equals(fieldName)) {
                    targetDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetLowPriorityNodes".equals(fieldName)) {
                    targetLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableAutoScale".equals(fieldName)) {
                    enableAutoScale = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoScaleFormula".equals(fieldName)) {
                    autoScaleFormula = reader.getString();
                    continue;
                }
                if ("autoScaleEvaluationInterval".equals(fieldName)) {
                    autoScaleEvaluationInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("enableInterNodeCommunication".equals(fieldName)) {
                    enableInterNodeCommunication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    startTask = BatchStartTask.fromJson(reader);
                    continue;
                }
                if ("certificateReferences".equals(fieldName)) {
                    certificateReferences = reader.readArray(reader1 -> BatchCertificateReference.fromJson(reader1));
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("taskSlotsPerNode".equals(fieldName)) {
                    taskSlotsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("taskSchedulingPolicy".equals(fieldName)) {
                    taskSchedulingPolicy = BatchTaskSchedulingPolicy.fromJson(reader);
                    continue;
                }
                if ("userAccounts".equals(fieldName)) {
                    userAccounts = reader.readArray(reader1 -> UserAccount.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> BatchMetadataItem.fromJson(reader1));
                    continue;
                }
                if ("mountConfiguration".equals(fieldName)) {
                    mountConfiguration = reader.readArray(reader1 -> MountConfiguration.fromJson(reader1));
                    continue;
                }
                if ("targetNodeCommunicationMode".equals(fieldName)) {
                    targetNodeCommunicationMode = BatchNodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("upgradePolicy".equals(fieldName)) {
                    upgradePolicy = UpgradePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchPoolCreateParameters deserializedBatchPoolCreateParameters = new BatchPoolCreateParameters(id, vmSize);
            deserializedBatchPoolCreateParameters.displayName = displayName;
            deserializedBatchPoolCreateParameters.virtualMachineConfiguration = virtualMachineConfiguration;
            deserializedBatchPoolCreateParameters.resizeTimeout = resizeTimeout;
            deserializedBatchPoolCreateParameters.resourceTags = resourceTags;
            deserializedBatchPoolCreateParameters.targetDedicatedNodes = targetDedicatedNodes;
            deserializedBatchPoolCreateParameters.targetLowPriorityNodes = targetLowPriorityNodes;
            deserializedBatchPoolCreateParameters.enableAutoScale = enableAutoScale;
            deserializedBatchPoolCreateParameters.autoScaleFormula = autoScaleFormula;
            deserializedBatchPoolCreateParameters.autoScaleEvaluationInterval = autoScaleEvaluationInterval;
            deserializedBatchPoolCreateParameters.enableInterNodeCommunication = enableInterNodeCommunication;
            deserializedBatchPoolCreateParameters.networkConfiguration = networkConfiguration;
            deserializedBatchPoolCreateParameters.startTask = startTask;
            deserializedBatchPoolCreateParameters.certificateReferences = certificateReferences;
            deserializedBatchPoolCreateParameters.applicationPackageReferences = applicationPackageReferences;
            deserializedBatchPoolCreateParameters.taskSlotsPerNode = taskSlotsPerNode;
            deserializedBatchPoolCreateParameters.taskSchedulingPolicy = taskSchedulingPolicy;
            deserializedBatchPoolCreateParameters.userAccounts = userAccounts;
            deserializedBatchPoolCreateParameters.metadata = metadata;
            deserializedBatchPoolCreateParameters.mountConfiguration = mountConfiguration;
            deserializedBatchPoolCreateParameters.targetNodeCommunicationMode = targetNodeCommunicationMode;
            deserializedBatchPoolCreateParameters.upgradePolicy = upgradePolicy;
            return deserializedBatchPoolCreateParameters;
        });
    }
}

