/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AllocationState;
import com.azure.compute.batch.models.AutoScaleRun;
import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchCertificateReference;
import com.azure.compute.batch.models.BatchMetadataItem;
import com.azure.compute.batch.models.BatchNodeCommunicationMode;
import com.azure.compute.batch.models.BatchPoolIdentity;
import com.azure.compute.batch.models.BatchPoolState;
import com.azure.compute.batch.models.BatchPoolStatistics;
import com.azure.compute.batch.models.BatchStartTask;
import com.azure.compute.batch.models.BatchTaskSchedulingPolicy;
import com.azure.compute.batch.models.MountConfiguration;
import com.azure.compute.batch.models.NetworkConfiguration;
import com.azure.compute.batch.models.ResizeError;
import com.azure.compute.batch.models.UpgradePolicy;
import com.azure.compute.batch.models.UserAccount;
import com.azure.compute.batch.models.VirtualMachineConfiguration;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BatchPool
implements JsonSerializable<BatchPool> {
    private String id;
    private String displayName;
    private String url;
    private String eTag;
    private OffsetDateTime lastModified;
    private OffsetDateTime creationTime;
    private BatchPoolState state;
    private OffsetDateTime stateTransitionTime;
    private AllocationState allocationState;
    private OffsetDateTime allocationStateTransitionTime;
    private String vmSize;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private Duration resizeTimeout;
    private List<ResizeError> resizeErrors;
    private Map<String, String> resourceTags;
    private Integer currentDedicatedNodes;
    private Integer currentLowPriorityNodes;
    private Integer targetDedicatedNodes;
    private Integer targetLowPriorityNodes;
    private Boolean enableAutoScale;
    private String autoScaleFormula;
    private Duration autoScaleEvaluationInterval;
    private AutoScaleRun autoScaleRun;
    private Boolean enableInterNodeCommunication;
    private NetworkConfiguration networkConfiguration;
    private BatchStartTask startTask;
    private List<BatchCertificateReference> certificateReferences;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private Integer taskSlotsPerNode;
    private BatchTaskSchedulingPolicy taskSchedulingPolicy;
    private List<UserAccount> userAccounts;
    private List<BatchMetadataItem> metadata;
    private List<MountConfiguration> mountConfiguration;
    private BatchPoolIdentity identity;
    private BatchNodeCommunicationMode targetNodeCommunicationMode;
    private BatchNodeCommunicationMode currentNodeCommunicationMode;
    private UpgradePolicy upgradePolicy;
    private BatchPoolStatistics poolStatistics;

    private BatchPool() {
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public BatchPoolState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public OffsetDateTime getAllocationStateTransitionTime() {
        return this.allocationStateTransitionTime;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public VirtualMachineConfiguration getVirtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public Duration getResizeTimeout() {
        return this.resizeTimeout;
    }

    public List<ResizeError> getResizeErrors() {
        return this.resizeErrors;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags;
    }

    public Integer getCurrentDedicatedNodes() {
        return this.currentDedicatedNodes;
    }

    public Integer getCurrentLowPriorityNodes() {
        return this.currentLowPriorityNodes;
    }

    public Integer getTargetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    public Integer getTargetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    public Boolean isEnableAutoScale() {
        return this.enableAutoScale;
    }

    public String getAutoScaleFormula() {
        return this.autoScaleFormula;
    }

    public Duration getAutoScaleEvaluationInterval() {
        return this.autoScaleEvaluationInterval;
    }

    public AutoScaleRun getAutoScaleRun() {
        return this.autoScaleRun;
    }

    public Boolean isEnableInterNodeCommunication() {
        return this.enableInterNodeCommunication;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchStartTask getStartTask() {
        return this.startTask;
    }

    public List<BatchCertificateReference> getCertificateReferences() {
        return this.certificateReferences;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public Integer getTaskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    public BatchTaskSchedulingPolicy getTaskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    public List<UserAccount> getUserAccounts() {
        return this.userAccounts;
    }

    public List<BatchMetadataItem> getMetadata() {
        return this.metadata;
    }

    public List<MountConfiguration> getMountConfiguration() {
        return this.mountConfiguration;
    }

    public BatchPoolIdentity getIdentity() {
        return this.identity;
    }

    public BatchNodeCommunicationMode getTargetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public BatchNodeCommunicationMode getCurrentNodeCommunicationMode() {
        return this.currentNodeCommunicationMode;
    }

    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeStringField("targetNodeCommunicationMode", this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        jsonWriter.writeJsonField("upgradePolicy", (JsonSerializable)this.upgradePolicy);
        return jsonWriter.writeEndObject();
    }

    public static BatchPool fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPool)jsonReader.readObject(reader -> {
            BatchPool deserializedBatchPool = new BatchPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchPool.id = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedBatchPool.displayName = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedBatchPool.url = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedBatchPool.eTag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedBatchPool.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedBatchPool.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedBatchPool.state = BatchPoolState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    deserializedBatchPool.stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("allocationState".equals(fieldName)) {
                    deserializedBatchPool.allocationState = AllocationState.fromString(reader.getString());
                    continue;
                }
                if ("allocationStateTransitionTime".equals(fieldName)) {
                    deserializedBatchPool.allocationStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedBatchPool.vmSize = reader.getString();
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedBatchPool.virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    deserializedBatchPool.resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("resizeErrors".equals(fieldName)) {
                    List resizeErrors;
                    deserializedBatchPool.resizeErrors = resizeErrors = reader.readArray(reader1 -> ResizeError.fromJson(reader1));
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    Map resourceTags;
                    deserializedBatchPool.resourceTags = resourceTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("currentDedicatedNodes".equals(fieldName)) {
                    deserializedBatchPool.currentDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentLowPriorityNodes".equals(fieldName)) {
                    deserializedBatchPool.currentLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedBatchPool.targetDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedBatchPool.targetLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableAutoScale".equals(fieldName)) {
                    deserializedBatchPool.enableAutoScale = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoScaleFormula".equals(fieldName)) {
                    deserializedBatchPool.autoScaleFormula = reader.getString();
                    continue;
                }
                if ("autoScaleEvaluationInterval".equals(fieldName)) {
                    deserializedBatchPool.autoScaleEvaluationInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("autoScaleRun".equals(fieldName)) {
                    deserializedBatchPool.autoScaleRun = AutoScaleRun.fromJson(reader);
                    continue;
                }
                if ("enableInterNodeCommunication".equals(fieldName)) {
                    deserializedBatchPool.enableInterNodeCommunication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedBatchPool.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    deserializedBatchPool.startTask = BatchStartTask.fromJson(reader);
                    continue;
                }
                if ("certificateReferences".equals(fieldName)) {
                    List certificateReferences;
                    deserializedBatchPool.certificateReferences = certificateReferences = reader.readArray(reader1 -> BatchCertificateReference.fromJson(reader1));
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    List applicationPackageReferences;
                    deserializedBatchPool.applicationPackageReferences = applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("taskSlotsPerNode".equals(fieldName)) {
                    deserializedBatchPool.taskSlotsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("taskSchedulingPolicy".equals(fieldName)) {
                    deserializedBatchPool.taskSchedulingPolicy = BatchTaskSchedulingPolicy.fromJson(reader);
                    continue;
                }
                if ("userAccounts".equals(fieldName)) {
                    List userAccounts;
                    deserializedBatchPool.userAccounts = userAccounts = reader.readArray(reader1 -> UserAccount.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBatchPool.metadata = metadata = reader.readArray(reader1 -> BatchMetadataItem.fromJson(reader1));
                    continue;
                }
                if ("stats".equals(fieldName)) {
                    deserializedBatchPool.poolStatistics = BatchPoolStatistics.fromJson(reader);
                    continue;
                }
                if ("mountConfiguration".equals(fieldName)) {
                    List mountConfiguration;
                    deserializedBatchPool.mountConfiguration = mountConfiguration = reader.readArray(reader1 -> MountConfiguration.fromJson(reader1));
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedBatchPool.identity = BatchPoolIdentity.fromJson(reader);
                    continue;
                }
                if ("targetNodeCommunicationMode".equals(fieldName)) {
                    deserializedBatchPool.targetNodeCommunicationMode = BatchNodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("currentNodeCommunicationMode".equals(fieldName)) {
                    deserializedBatchPool.currentNodeCommunicationMode = BatchNodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("upgradePolicy".equals(fieldName)) {
                    deserializedBatchPool.upgradePolicy = UpgradePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPool;
        });
    }

    public BatchPoolStatistics getPoolStatistics() {
        return this.poolStatistics;
    }
}

