/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchDiffDiskSettings;
import com.azure.compute.batch.models.CachingType;
import com.azure.compute.batch.models.ManagedDisk;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchOsDisk
implements JsonSerializable<BatchOsDisk> {
    private BatchDiffDiskSettings ephemeralOSDiskSettings;
    private CachingType caching;
    private Integer diskSizeGB;
    private ManagedDisk managedDisk;
    private Boolean writeAcceleratorEnabled;

    public BatchDiffDiskSettings getEphemeralOSDiskSettings() {
        return this.ephemeralOSDiskSettings;
    }

    public BatchOsDisk setEphemeralOSDiskSettings(BatchDiffDiskSettings ephemeralOSDiskSettings) {
        this.ephemeralOSDiskSettings = ephemeralOSDiskSettings;
        return this;
    }

    public CachingType getCaching() {
        return this.caching;
    }

    public BatchOsDisk setCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public BatchOsDisk setDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public ManagedDisk getManagedDisk() {
        return this.managedDisk;
    }

    public BatchOsDisk setManagedDisk(ManagedDisk managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public Boolean isWriteAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public BatchOsDisk setWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("ephemeralOSDiskSettings", (JsonSerializable)this.ephemeralOSDiskSettings);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    public static BatchOsDisk fromJson(JsonReader jsonReader) throws IOException {
        return (BatchOsDisk)jsonReader.readObject(reader -> {
            BatchOsDisk deserializedBatchOsDisk = new BatchOsDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ephemeralOSDiskSettings".equals(fieldName)) {
                    deserializedBatchOsDisk.ephemeralOSDiskSettings = BatchDiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedBatchOsDisk.caching = CachingType.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedBatchOsDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedBatchOsDisk.managedDisk = ManagedDisk.fromJson(reader);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedBatchOsDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchOsDisk;
        });
    }
}

