/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchNodeUserUpdateParameters
implements JsonSerializable<BatchNodeUserUpdateParameters> {
    private String password;
    private OffsetDateTime expiryTime;
    private String sshPublicKey;

    public String getPassword() {
        return this.password;
    }

    public BatchNodeUserUpdateParameters setPassword(String password) {
        this.password = password;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public BatchNodeUserUpdateParameters setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public BatchNodeUserUpdateParameters setSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("sshPublicKey", this.sshPublicKey);
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeUserUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeUserUpdateParameters)jsonReader.readObject(reader -> {
            BatchNodeUserUpdateParameters deserializedBatchNodeUserUpdateParameters = new BatchNodeUserUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("password".equals(fieldName)) {
                    deserializedBatchNodeUserUpdateParameters.password = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedBatchNodeUserUpdateParameters.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    deserializedBatchNodeUserUpdateParameters.sshPublicKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchNodeUserUpdateParameters;
        });
    }
}

