/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchNodeUserCreateParameters
implements JsonSerializable<BatchNodeUserCreateParameters> {
    private final String name;
    private Boolean isAdmin;
    private OffsetDateTime expiryTime;
    private String password;
    private String sshPublicKey;

    public BatchNodeUserCreateParameters(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isAdmin() {
        return this.isAdmin;
    }

    public BatchNodeUserCreateParameters setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public BatchNodeUserCreateParameters setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public BatchNodeUserCreateParameters setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public BatchNodeUserCreateParameters setSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isAdmin", this.isAdmin);
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("sshPublicKey", this.sshPublicKey);
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeUserCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeUserCreateParameters)jsonReader.readObject(reader -> {
            String name = null;
            Boolean isAdmin = null;
            OffsetDateTime expiryTime = null;
            String password = null;
            String sshPublicKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("isAdmin".equals(fieldName)) {
                    isAdmin = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("password".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    sshPublicKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BatchNodeUserCreateParameters deserializedBatchNodeUserCreateParameters = new BatchNodeUserCreateParameters(name);
            deserializedBatchNodeUserCreateParameters.isAdmin = isAdmin;
            deserializedBatchNodeUserCreateParameters.expiryTime = expiryTime;
            deserializedBatchNodeUserCreateParameters.password = password;
            deserializedBatchNodeUserCreateParameters.sshPublicKey = sshPublicKey;
            return deserializedBatchNodeUserCreateParameters;
        });
    }
}

