/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeDeallocationOption;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class BatchNodeRemoveParameters
implements JsonSerializable<BatchNodeRemoveParameters> {
    private final List<String> nodeIds;
    private Duration resizeTimeout;
    private BatchNodeDeallocationOption nodeDeallocationOption;

    public BatchNodeRemoveParameters(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public Duration getResizeTimeout() {
        return this.resizeTimeout;
    }

    public BatchNodeRemoveParameters setResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public BatchNodeDeallocationOption getNodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    public BatchNodeRemoveParameters setNodeDeallocationOption(BatchNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nodeList", this.nodeIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeStringField("nodeDeallocationOption", this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeRemoveParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeRemoveParameters)jsonReader.readObject(reader -> {
            List nodeIds = null;
            Duration resizeTimeout = null;
            BatchNodeDeallocationOption nodeDeallocationOption = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeList".equals(fieldName)) {
                    nodeIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("nodeDeallocationOption".equals(fieldName)) {
                    nodeDeallocationOption = BatchNodeDeallocationOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchNodeRemoveParameters deserializedBatchNodeRemoveParameters = new BatchNodeRemoveParameters(nodeIds);
            deserializedBatchNodeRemoveParameters.resizeTimeout = resizeTimeout;
            deserializedBatchNodeRemoveParameters.nodeDeallocationOption = nodeDeallocationOption;
            return deserializedBatchNodeRemoveParameters;
        });
    }
}

