/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchNodeRemoteLoginSettings
implements JsonSerializable<BatchNodeRemoteLoginSettings> {
    private final String remoteLoginIpAddress;
    private final int remoteLoginPort;

    private BatchNodeRemoteLoginSettings(String remoteLoginIpAddress, int remoteLoginPort) {
        this.remoteLoginIpAddress = remoteLoginIpAddress;
        this.remoteLoginPort = remoteLoginPort;
    }

    public String getRemoteLoginIpAddress() {
        return this.remoteLoginIpAddress;
    }

    public int getRemoteLoginPort() {
        return this.remoteLoginPort;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("remoteLoginIPAddress", this.remoteLoginIpAddress);
        jsonWriter.writeIntField("remoteLoginPort", this.remoteLoginPort);
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeRemoteLoginSettings fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeRemoteLoginSettings)jsonReader.readObject(reader -> {
            String remoteLoginIpAddress = null;
            int remoteLoginPort = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("remoteLoginIPAddress".equals(fieldName)) {
                    remoteLoginIpAddress = reader.getString();
                    continue;
                }
                if ("remoteLoginPort".equals(fieldName)) {
                    remoteLoginPort = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchNodeRemoteLoginSettings(remoteLoginIpAddress, remoteLoginPort);
        });
    }
}

