/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.NameValuePair;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchNodeError
implements JsonSerializable<BatchNodeError> {
    private String code;
    private String message;
    private List<NameValuePair> errorDetails;

    private BatchNodeError() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<NameValuePair> getErrorDetails() {
        return this.errorDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("errorDetails", this.errorDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeError fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeError)jsonReader.readObject(reader -> {
            BatchNodeError deserializedBatchNodeError = new BatchNodeError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedBatchNodeError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedBatchNodeError.message = reader.getString();
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    List errorDetails;
                    deserializedBatchNodeError.errorDetails = errorDetails = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchNodeError;
        });
    }
}

