/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchAllTasksCompleteMode;
import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchMetadataItem;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobUpdateParameters
implements JsonSerializable<BatchJobUpdateParameters> {
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private BatchJobConstraints constraints;
    private BatchPoolInfo poolInfo;
    private BatchAllTasksCompleteMode allTasksCompleteMode;
    private List<BatchMetadataItem> metadata;
    private BatchJobNetworkConfiguration networkConfiguration;

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJobUpdateParameters setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJobUpdateParameters setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJobUpdateParameters setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobUpdateParameters setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public BatchJobUpdateParameters setPoolInfo(BatchPoolInfo poolInfo) {
        this.poolInfo = poolInfo;
        return this;
    }

    public BatchAllTasksCompleteMode getAllTasksCompleteMode() {
        return this.allTasksCompleteMode;
    }

    public BatchJobUpdateParameters setAllTasksCompleteMode(BatchAllTasksCompleteMode allTasksCompleteMode) {
        this.allTasksCompleteMode = allTasksCompleteMode;
        return this;
    }

    public List<BatchMetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobUpdateParameters setMetadata(List<BatchMetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchJobUpdateParameters setNetworkConfiguration(BatchJobNetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeStringField("onAllTasksComplete", this.allTasksCompleteMode == null ? null : this.allTasksCompleteMode.toString());
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobUpdateParameters)jsonReader.readObject(reader -> {
            BatchJobUpdateParameters deserializedBatchJobUpdateParameters = new BatchJobUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("poolInfo".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.allTasksCompleteMode = BatchAllTasksCompleteMode.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBatchJobUpdateParameters.metadata = metadata = reader.readArray(reader1 -> BatchMetadataItem.fromJson(reader1));
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedBatchJobUpdateParameters.networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobUpdateParameters;
        });
    }
}

