/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class BatchJobStatistics
implements JsonSerializable<BatchJobStatistics> {
    private final String url;
    private final OffsetDateTime startTime;
    private final OffsetDateTime lastUpdateTime;
    private final Duration userCpuTime;
    private final Duration kernelCpuTime;
    private final Duration wallClockTime;
    private final Duration waitTime;
    private final long readIops;
    private final long writeIops;
    private final double readIoGiB;
    private final double writeIoGiB;
    private final long succeededTasksCount;
    private final long failedTasksCount;
    private final long taskRetriesCount;

    private BatchJobStatistics(String url, OffsetDateTime startTime, OffsetDateTime lastUpdateTime, Duration userCpuTime, Duration kernelCpuTime, Duration wallClockTime, long readIops, long writeIops, double readIoGiB, double writeIoGiB, long succeededTasksCount, long failedTasksCount, long taskRetriesCount, Duration waitTime) {
        this.url = url;
        this.startTime = startTime;
        this.lastUpdateTime = lastUpdateTime;
        this.userCpuTime = userCpuTime;
        this.kernelCpuTime = kernelCpuTime;
        this.wallClockTime = wallClockTime;
        this.readIops = readIops;
        this.writeIops = writeIops;
        this.readIoGiB = readIoGiB;
        this.writeIoGiB = writeIoGiB;
        this.succeededTasksCount = succeededTasksCount;
        this.failedTasksCount = failedTasksCount;
        this.taskRetriesCount = taskRetriesCount;
        this.waitTime = waitTime;
    }

    public String getUrl() {
        return this.url;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Duration getUserCpuTime() {
        return this.userCpuTime;
    }

    public Duration getKernelCpuTime() {
        return this.kernelCpuTime;
    }

    public Duration getWallClockTime() {
        return this.wallClockTime;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        jsonWriter.writeStringField("userCPUTime", CoreUtils.durationToStringWithDays((Duration)this.userCpuTime));
        jsonWriter.writeStringField("kernelCPUTime", CoreUtils.durationToStringWithDays((Duration)this.kernelCpuTime));
        jsonWriter.writeStringField("wallClockTime", CoreUtils.durationToStringWithDays((Duration)this.wallClockTime));
        jsonWriter.writeStringField("readIOps", Objects.toString(this.readIops, null));
        jsonWriter.writeStringField("writeIOps", Objects.toString(this.writeIops, null));
        jsonWriter.writeDoubleField("readIOGiB", this.readIoGiB);
        jsonWriter.writeDoubleField("writeIOGiB", this.writeIoGiB);
        jsonWriter.writeStringField("numSucceededTasks", Objects.toString(this.succeededTasksCount, null));
        jsonWriter.writeStringField("numFailedTasks", Objects.toString(this.failedTasksCount, null));
        jsonWriter.writeStringField("numTaskRetries", Objects.toString(this.taskRetriesCount, null));
        jsonWriter.writeStringField("waitTime", CoreUtils.durationToStringWithDays((Duration)this.waitTime));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobStatistics)jsonReader.readObject(reader -> {
            String url = null;
            OffsetDateTime startTime = null;
            OffsetDateTime lastUpdateTime = null;
            Duration userCpuTime = null;
            Duration kernelCpuTime = null;
            Duration wallClockTime = null;
            long readIops = Long.parseLong("0");
            long writeIops = Long.parseLong("0");
            double readIoGiB = 0.0;
            double writeIoGiB = 0.0;
            long succeededTasksCount = Long.parseLong("0");
            long failedTasksCount = Long.parseLong("0");
            long taskRetriesCount = Long.parseLong("0");
            Duration waitTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("userCPUTime".equals(fieldName)) {
                    userCpuTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("kernelCPUTime".equals(fieldName)) {
                    kernelCpuTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("wallClockTime".equals(fieldName)) {
                    wallClockTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("readIOps".equals(fieldName)) {
                    readIops = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("writeIOps".equals(fieldName)) {
                    writeIops = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("readIOGiB".equals(fieldName)) {
                    readIoGiB = reader.getDouble();
                    continue;
                }
                if ("writeIOGiB".equals(fieldName)) {
                    writeIoGiB = reader.getDouble();
                    continue;
                }
                if ("numSucceededTasks".equals(fieldName)) {
                    succeededTasksCount = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("numFailedTasks".equals(fieldName)) {
                    failedTasksCount = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("numTaskRetries".equals(fieldName)) {
                    taskRetriesCount = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("waitTime".equals(fieldName)) {
                    waitTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchJobStatistics(url, startTime, lastUpdateTime, userCpuTime, kernelCpuTime, wallClockTime, readIops, writeIops, readIoGiB, writeIoGiB, succeededTasksCount, failedTasksCount, taskRetriesCount, waitTime);
        });
    }

    public long getReadIops() {
        return this.readIops;
    }

    public long getWriteIops() {
        return this.writeIops;
    }

    public double getReadIoGiB() {
        return this.readIoGiB;
    }

    public double getWriteIoGiB() {
        return this.writeIoGiB;
    }

    public long getSucceededTasksCount() {
        return this.succeededTasksCount;
    }

    public long getFailedTasksCount() {
        return this.failedTasksCount;
    }

    public long getTaskRetriesCount() {
        return this.taskRetriesCount;
    }
}

