/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchErrorSourceCategory;
import com.azure.compute.batch.models.NameValuePair;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobSchedulingError
implements JsonSerializable<BatchJobSchedulingError> {
    private final BatchErrorSourceCategory category;
    private String code;
    private String message;
    private List<NameValuePair> details;

    public BatchErrorSourceCategory getCategory() {
        return this.category;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<NameValuePair> getDetails() {
        return this.details;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobSchedulingError fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobSchedulingError)jsonReader.readObject(reader -> {
            BatchErrorSourceCategory category = null;
            String code = null;
            String message = null;
            List details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    category = BatchErrorSourceCategory.fromString(reader.getString());
                    continue;
                }
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobSchedulingError deserializedBatchJobSchedulingError = new BatchJobSchedulingError(category);
            deserializedBatchJobSchedulingError.code = code;
            deserializedBatchJobSchedulingError.message = message;
            deserializedBatchJobSchedulingError.details = details;
            return deserializedBatchJobSchedulingError;
        });
    }

    private BatchJobSchedulingError(BatchErrorSourceCategory category) {
        this.category = category;
    }
}

