/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobScheduleConfiguration;
import com.azure.compute.batch.models.BatchJobSpecification;
import com.azure.compute.batch.models.BatchMetadataItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobScheduleUpdateParameters
implements JsonSerializable<BatchJobScheduleUpdateParameters> {
    private BatchJobScheduleConfiguration schedule;
    private BatchJobSpecification jobSpecification;
    private List<BatchMetadataItem> metadata;

    public BatchJobScheduleConfiguration getSchedule() {
        return this.schedule;
    }

    public BatchJobScheduleUpdateParameters setSchedule(BatchJobScheduleConfiguration schedule) {
        this.schedule = schedule;
        return this;
    }

    public BatchJobSpecification getJobSpecification() {
        return this.jobSpecification;
    }

    public BatchJobScheduleUpdateParameters setJobSpecification(BatchJobSpecification jobSpecification) {
        this.jobSpecification = jobSpecification;
        return this;
    }

    public List<BatchMetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobScheduleUpdateParameters setMetadata(List<BatchMetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeJsonField("jobSpecification", (JsonSerializable)this.jobSpecification);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobScheduleUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobScheduleUpdateParameters)jsonReader.readObject(reader -> {
            BatchJobScheduleUpdateParameters deserializedBatchJobScheduleUpdateParameters = new BatchJobScheduleUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schedule".equals(fieldName)) {
                    deserializedBatchJobScheduleUpdateParameters.schedule = BatchJobScheduleConfiguration.fromJson(reader);
                    continue;
                }
                if ("jobSpecification".equals(fieldName)) {
                    deserializedBatchJobScheduleUpdateParameters.jobSpecification = BatchJobSpecification.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBatchJobScheduleUpdateParameters.metadata = metadata = reader.readArray(reader1 -> BatchMetadataItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobScheduleUpdateParameters;
        });
    }
}

