/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchJobScheduleConfiguration
implements JsonSerializable<BatchJobScheduleConfiguration> {
    private OffsetDateTime doNotRunUntil;
    private OffsetDateTime doNotRunAfter;
    private Duration startWindow;
    private Duration recurrenceInterval;

    public OffsetDateTime getDoNotRunUntil() {
        return this.doNotRunUntil;
    }

    public BatchJobScheduleConfiguration setDoNotRunUntil(OffsetDateTime doNotRunUntil) {
        this.doNotRunUntil = doNotRunUntil;
        return this;
    }

    public OffsetDateTime getDoNotRunAfter() {
        return this.doNotRunAfter;
    }

    public BatchJobScheduleConfiguration setDoNotRunAfter(OffsetDateTime doNotRunAfter) {
        this.doNotRunAfter = doNotRunAfter;
        return this;
    }

    public Duration getStartWindow() {
        return this.startWindow;
    }

    public BatchJobScheduleConfiguration setStartWindow(Duration startWindow) {
        this.startWindow = startWindow;
        return this;
    }

    public Duration getRecurrenceInterval() {
        return this.recurrenceInterval;
    }

    public BatchJobScheduleConfiguration setRecurrenceInterval(Duration recurrenceInterval) {
        this.recurrenceInterval = recurrenceInterval;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("doNotRunUntil", this.doNotRunUntil == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.doNotRunUntil));
        jsonWriter.writeStringField("doNotRunAfter", this.doNotRunAfter == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.doNotRunAfter));
        jsonWriter.writeStringField("startWindow", CoreUtils.durationToStringWithDays((Duration)this.startWindow));
        jsonWriter.writeStringField("recurrenceInterval", CoreUtils.durationToStringWithDays((Duration)this.recurrenceInterval));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobScheduleConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobScheduleConfiguration)jsonReader.readObject(reader -> {
            BatchJobScheduleConfiguration deserializedBatchJobScheduleConfiguration = new BatchJobScheduleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("doNotRunUntil".equals(fieldName)) {
                    deserializedBatchJobScheduleConfiguration.doNotRunUntil = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("doNotRunAfter".equals(fieldName)) {
                    deserializedBatchJobScheduleConfiguration.doNotRunAfter = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startWindow".equals(fieldName)) {
                    deserializedBatchJobScheduleConfiguration.startWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("recurrenceInterval".equals(fieldName)) {
                    deserializedBatchJobScheduleConfiguration.recurrenceInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobScheduleConfiguration;
        });
    }
}

