/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchJobNetworkConfiguration
implements JsonSerializable<BatchJobNetworkConfiguration> {
    private final String subnetId;
    private Boolean skipWithdrawFromVnet;

    public String getSubnetId() {
        return this.subnetId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeBooleanField("skipWithdrawFromVNet", this.skipWithdrawFromVnet);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobNetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobNetworkConfiguration)jsonReader.readObject(reader -> {
            String subnetId = null;
            Boolean skipWithdrawFromVnet = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    subnetId = reader.getString();
                    continue;
                }
                if ("skipWithdrawFromVNet".equals(fieldName)) {
                    skipWithdrawFromVnet = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobNetworkConfiguration deserializedBatchJobNetworkConfiguration = new BatchJobNetworkConfiguration(subnetId);
            deserializedBatchJobNetworkConfiguration.skipWithdrawFromVnet = skipWithdrawFromVnet;
            return deserializedBatchJobNetworkConfiguration;
        });
    }

    public Boolean isSkipWithdrawFromVnet() {
        return this.skipWithdrawFromVnet;
    }

    public BatchJobNetworkConfiguration(String subnetId) {
        this.subnetId = subnetId;
    }

    public BatchJobNetworkConfiguration setSkipWithdrawFromVnet(Boolean skipWithdrawFromVnet) {
        this.skipWithdrawFromVnet = skipWithdrawFromVnet;
        return this;
    }
}

