/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchAllTasksCompleteMode;
import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobManagerTask;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchJobPreparationTask;
import com.azure.compute.batch.models.BatchJobReleaseTask;
import com.azure.compute.batch.models.BatchMetadataItem;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.compute.batch.models.BatchTaskFailureMode;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobCreateParameters
implements JsonSerializable<BatchJobCreateParameters> {
    private final String id;
    private String displayName;
    private Boolean usesTaskDependencies;
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private BatchJobConstraints constraints;
    private BatchJobManagerTask jobManagerTask;
    private BatchJobPreparationTask jobPreparationTask;
    private BatchJobReleaseTask jobReleaseTask;
    private List<EnvironmentSetting> commonEnvironmentSettings;
    private final BatchPoolInfo poolInfo;
    private BatchAllTasksCompleteMode allTasksCompleteMode;
    private BatchTaskFailureMode taskFailureMode;
    private BatchJobNetworkConfiguration networkConfiguration;
    private List<BatchMetadataItem> metadata;

    public BatchJobCreateParameters(String id, BatchPoolInfo poolInfo) {
        this.id = id;
        this.poolInfo = poolInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchJobCreateParameters setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean isUsesTaskDependencies() {
        return this.usesTaskDependencies;
    }

    public BatchJobCreateParameters setUsesTaskDependencies(Boolean usesTaskDependencies) {
        this.usesTaskDependencies = usesTaskDependencies;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJobCreateParameters setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJobCreateParameters setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJobCreateParameters setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobCreateParameters setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchJobManagerTask getJobManagerTask() {
        return this.jobManagerTask;
    }

    public BatchJobCreateParameters setJobManagerTask(BatchJobManagerTask jobManagerTask) {
        this.jobManagerTask = jobManagerTask;
        return this;
    }

    public BatchJobPreparationTask getJobPreparationTask() {
        return this.jobPreparationTask;
    }

    public BatchJobCreateParameters setJobPreparationTask(BatchJobPreparationTask jobPreparationTask) {
        this.jobPreparationTask = jobPreparationTask;
        return this;
    }

    public BatchJobReleaseTask getJobReleaseTask() {
        return this.jobReleaseTask;
    }

    public BatchJobCreateParameters setJobReleaseTask(BatchJobReleaseTask jobReleaseTask) {
        this.jobReleaseTask = jobReleaseTask;
        return this;
    }

    public List<EnvironmentSetting> getCommonEnvironmentSettings() {
        return this.commonEnvironmentSettings;
    }

    public BatchJobCreateParameters setCommonEnvironmentSettings(List<EnvironmentSetting> commonEnvironmentSettings) {
        this.commonEnvironmentSettings = commonEnvironmentSettings;
        return this;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public BatchAllTasksCompleteMode getAllTasksCompleteMode() {
        return this.allTasksCompleteMode;
    }

    public BatchJobCreateParameters setAllTasksCompleteMode(BatchAllTasksCompleteMode allTasksCompleteMode) {
        this.allTasksCompleteMode = allTasksCompleteMode;
        return this;
    }

    public BatchTaskFailureMode getTaskFailureMode() {
        return this.taskFailureMode;
    }

    public BatchJobCreateParameters setTaskFailureMode(BatchTaskFailureMode taskFailureMode) {
        this.taskFailureMode = taskFailureMode;
        return this;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchJobCreateParameters setNetworkConfiguration(BatchJobNetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public List<BatchMetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobCreateParameters setMetadata(List<BatchMetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("usesTaskDependencies", this.usesTaskDependencies);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeJsonField("jobManagerTask", (JsonSerializable)this.jobManagerTask);
        jsonWriter.writeJsonField("jobPreparationTask", (JsonSerializable)this.jobPreparationTask);
        jsonWriter.writeJsonField("jobReleaseTask", (JsonSerializable)this.jobReleaseTask);
        jsonWriter.writeArrayField("commonEnvironmentSettings", this.commonEnvironmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("onAllTasksComplete", this.allTasksCompleteMode == null ? null : this.allTasksCompleteMode.toString());
        jsonWriter.writeStringField("onTaskFailure", this.taskFailureMode == null ? null : this.taskFailureMode.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobCreateParameters)jsonReader.readObject(reader -> {
            String id = null;
            BatchPoolInfo poolInfo = null;
            String displayName = null;
            Boolean usesTaskDependencies = null;
            Integer priority = null;
            Boolean allowTaskPreemption = null;
            Integer maxParallelTasks = null;
            BatchJobConstraints constraints = null;
            BatchJobManagerTask jobManagerTask = null;
            BatchJobPreparationTask jobPreparationTask = null;
            BatchJobReleaseTask jobReleaseTask = null;
            List commonEnvironmentSettings = null;
            BatchAllTasksCompleteMode allTasksCompleteMode = null;
            BatchTaskFailureMode taskFailureMode = null;
            BatchJobNetworkConfiguration networkConfiguration = null;
            List metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("poolInfo".equals(fieldName)) {
                    poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("usesTaskDependencies".equals(fieldName)) {
                    usesTaskDependencies = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("jobManagerTask".equals(fieldName)) {
                    jobManagerTask = BatchJobManagerTask.fromJson(reader);
                    continue;
                }
                if ("jobPreparationTask".equals(fieldName)) {
                    jobPreparationTask = BatchJobPreparationTask.fromJson(reader);
                    continue;
                }
                if ("jobReleaseTask".equals(fieldName)) {
                    jobReleaseTask = BatchJobReleaseTask.fromJson(reader);
                    continue;
                }
                if ("commonEnvironmentSettings".equals(fieldName)) {
                    commonEnvironmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    allTasksCompleteMode = BatchAllTasksCompleteMode.fromString(reader.getString());
                    continue;
                }
                if ("onTaskFailure".equals(fieldName)) {
                    taskFailureMode = BatchTaskFailureMode.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> BatchMetadataItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobCreateParameters deserializedBatchJobCreateParameters = new BatchJobCreateParameters(id, poolInfo);
            deserializedBatchJobCreateParameters.displayName = displayName;
            deserializedBatchJobCreateParameters.usesTaskDependencies = usesTaskDependencies;
            deserializedBatchJobCreateParameters.priority = priority;
            deserializedBatchJobCreateParameters.allowTaskPreemption = allowTaskPreemption;
            deserializedBatchJobCreateParameters.maxParallelTasks = maxParallelTasks;
            deserializedBatchJobCreateParameters.constraints = constraints;
            deserializedBatchJobCreateParameters.jobManagerTask = jobManagerTask;
            deserializedBatchJobCreateParameters.jobPreparationTask = jobPreparationTask;
            deserializedBatchJobCreateParameters.jobReleaseTask = jobReleaseTask;
            deserializedBatchJobCreateParameters.commonEnvironmentSettings = commonEnvironmentSettings;
            deserializedBatchJobCreateParameters.allTasksCompleteMode = allTasksCompleteMode;
            deserializedBatchJobCreateParameters.taskFailureMode = taskFailureMode;
            deserializedBatchJobCreateParameters.networkConfiguration = networkConfiguration;
            deserializedBatchJobCreateParameters.metadata = metadata;
            return deserializedBatchJobCreateParameters;
        });
    }
}

