/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class BatchFileProperties {
    private final HttpHeaders headers;

    public BatchFileProperties(HttpHeaders headers) {
        this.headers = headers;
    }

    public OffsetDateTime getOcpCreationTime() {
        String headerValue = this.headers.getValue(HttpHeaderName.fromString((String)"ocp-creation-time"));
        return headerValue != null ? OffsetDateTime.parse(headerValue, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
    }

    public boolean isOcpBatchFileIsDirectory() {
        String headerValue = this.headers.getValue(HttpHeaderName.fromString((String)"ocp-batch-file-isdirectory"));
        return Boolean.parseBoolean(headerValue);
    }

    public String getOcpBatchFileUrl() {
        return this.headers.getValue(HttpHeaderName.fromString((String)"ocp-batch-file-url"));
    }

    public String getOcpBatchFileMode() {
        return this.headers.getValue(HttpHeaderName.fromString((String)"ocp-batch-file-mode"));
    }

    public long getContentLength() {
        String value = this.headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

