/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchCertificateDeleteError;
import com.azure.compute.batch.models.BatchCertificateFormat;
import com.azure.compute.batch.models.BatchCertificateState;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BatchCertificate
implements JsonSerializable<BatchCertificate> {
    private final String thumbprint;
    private final String thumbprintAlgorithm;
    private String url;
    private BatchCertificateState state;
    private OffsetDateTime stateTransitionTime;
    private BatchCertificateState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private String publicData;
    private BatchCertificateDeleteError deleteCertificateError;
    private final byte[] data;
    private BatchCertificateFormat certificateFormat;
    private String password;

    public String getThumbprint() {
        return this.thumbprint;
    }

    public String getThumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    public String getUrl() {
        return this.url;
    }

    public BatchCertificateState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchCertificateState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public String getPublicData() {
        return this.publicData;
    }

    public BatchCertificateDeleteError getDeleteCertificateError() {
        return this.deleteCertificateError;
    }

    public byte[] getData() {
        return CoreUtils.clone((byte[])this.data);
    }

    public BatchCertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public BatchCertificate setCertificateFormat(BatchCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public BatchCertificate setPassword(String password) {
        this.password = password;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm);
        jsonWriter.writeBinaryField("data", this.data);
        jsonWriter.writeStringField("certificateFormat", this.certificateFormat == null ? null : this.certificateFormat.toString());
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static BatchCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (BatchCertificate)jsonReader.readObject(reader -> {
            String thumbprint = null;
            String thumbprintAlgorithm = null;
            byte[] data = null;
            String url = null;
            BatchCertificateState state = null;
            OffsetDateTime stateTransitionTime = null;
            BatchCertificateState previousState = null;
            OffsetDateTime previousStateTransitionTime = null;
            String publicData = null;
            BatchCertificateDeleteError deleteCertificateError = null;
            BatchCertificateFormat certificateFormat = null;
            String password = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprint".equals(fieldName)) {
                    thumbprint = reader.getString();
                    continue;
                }
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    thumbprintAlgorithm = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    data = reader.getBinary();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchCertificateState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    previousState = BatchCertificateState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("publicData".equals(fieldName)) {
                    publicData = reader.getString();
                    continue;
                }
                if ("deleteCertificateError".equals(fieldName)) {
                    deleteCertificateError = BatchCertificateDeleteError.fromJson(reader);
                    continue;
                }
                if ("certificateFormat".equals(fieldName)) {
                    certificateFormat = BatchCertificateFormat.fromString(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BatchCertificate deserializedBatchCertificate = new BatchCertificate(thumbprint, thumbprintAlgorithm, data);
            deserializedBatchCertificate.url = url;
            deserializedBatchCertificate.state = state;
            deserializedBatchCertificate.stateTransitionTime = stateTransitionTime;
            deserializedBatchCertificate.previousState = previousState;
            deserializedBatchCertificate.previousStateTransitionTime = previousStateTransitionTime;
            deserializedBatchCertificate.publicData = publicData;
            deserializedBatchCertificate.deleteCertificateError = deleteCertificateError;
            deserializedBatchCertificate.certificateFormat = certificateFormat;
            deserializedBatchCertificate.password = password;
            return deserializedBatchCertificate;
        });
    }

    public BatchCertificate(String thumbprint, String thumbprintAlgorithm, byte[] data) {
        this.thumbprint = thumbprint;
        this.thumbprintAlgorithm = thumbprintAlgorithm;
        this.data = data;
    }
}

