/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchApplication
implements JsonSerializable<BatchApplication> {
    private final String id;
    private final String displayName;
    private final List<String> versions;

    private BatchApplication(String id, String displayName, List<String> versions) {
        this.id = id;
        this.displayName = displayName;
        this.versions = versions;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("versions", this.versions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BatchApplication fromJson(JsonReader jsonReader) throws IOException {
        return (BatchApplication)jsonReader.readObject(reader -> {
            String id = null;
            String displayName = null;
            List versions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("versions".equals(fieldName)) {
                    versions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchApplication(id, displayName, versions);
        });
    }
}

