/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.implementation.task;

import com.azure.compute.batch.BatchClient;
import com.azure.compute.batch.implementation.task.TaskSubmitter;
import com.azure.compute.batch.models.BatchCreateTaskCollectionResult;
import com.azure.compute.batch.models.BatchError;
import com.azure.compute.batch.models.BatchErrorException;
import com.azure.compute.batch.models.BatchTaskAddStatus;
import com.azure.compute.batch.models.BatchTaskBulkCreateOptions;
import com.azure.compute.batch.models.BatchTaskCreateParameters;
import com.azure.compute.batch.models.BatchTaskCreateResult;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.CreateTasksErrorException;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTasks(TaskSubmitter taskSubmitter, String jobId, Collection<BatchTaskCreateParameters> taskList, BatchTaskBulkCreateOptions taskCreateOptions) {
        ClientLogger logger = new ClientLogger(BatchClient.class);
        WorkingThread.CURRENT_MAX_TASKS.set(100);
        int threadNumber = 1;
        if (taskCreateOptions != null && taskCreateOptions.getMaxConcurrency() != null) {
            threadNumber = taskCreateOptions.getMaxConcurrency();
        }
        Iterator lock = new Iterator();
        ConcurrentLinkedQueue<BatchTaskCreateParameters> pendingList = new ConcurrentLinkedQueue<BatchTaskCreateParameters>(taskList);
        CopyOnWriteArrayList<BatchTaskCreateResult> failures = new CopyOnWriteArrayList<BatchTaskCreateResult>();
        HashMap<Object, WorkingThread> threads = new HashMap<Object, WorkingThread>();
        Exception innerException = null;
        AtomicInteger activeThreadCounter = new AtomicInteger(0);
        Iterator<Object> iterator = lock;
        synchronized (iterator) {
            while (!pendingList.isEmpty() || activeThreadCounter.get() > 0) {
                if (threads.size() < threadNumber && !pendingList.isEmpty()) {
                    WorkingThread worker = new WorkingThread(taskSubmitter, jobId, pendingList, failures, lock, activeThreadCounter);
                    Thread thread = new Thread(worker);
                    activeThreadCounter.incrementAndGet();
                    thread.start();
                    threads.put(thread, worker);
                    continue;
                }
                if (activeThreadCounter.get() <= 0) continue;
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw logger.logExceptionAsError(new RuntimeException(e));
                }
                ArrayList<Thread> finishedThreads = new ArrayList<Thread>();
                for (Map.Entry entry : threads.entrySet()) {
                    if (((Thread)entry.getKey()).getState() != Thread.State.TERMINATED) continue;
                    finishedThreads.add((Thread)entry.getKey());
                    innerException = ((WorkingThread)entry.getValue()).getException();
                    if (innerException == null) continue;
                    break;
                }
                threads.keySet().removeAll(finishedThreads);
                if (innerException == null && failures.isEmpty()) continue;
                break;
            }
        }
        for (Thread t : threads.keySet()) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw logger.logExceptionAsError(new RuntimeException(e));
            }
        }
        if (innerException == null) {
            Map.Entry entry;
            iterator = threads.entrySet().iterator();
            while (iterator.hasNext() && (innerException = ((WorkingThread)(entry = (Map.Entry)iterator.next()).getValue()).getException()) == null) {
            }
        }
        if (innerException != null) {
            if (innerException instanceof BatchErrorException) {
                throw logger.logExceptionAsError((RuntimeException)((Object)((BatchErrorException)((Object)innerException))));
            }
            if (innerException instanceof RuntimeException) {
                throw logger.logExceptionAsError((RuntimeException)innerException);
            }
            throw logger.logExceptionAsError(new RuntimeException(innerException));
        }
        if (!failures.isEmpty()) {
            ArrayList<BatchTaskCreateParameters> notFinished = new ArrayList<BatchTaskCreateParameters>();
            for (BatchTaskCreateParameters param : pendingList) {
                notFinished.add(param);
            }
            throw new CreateTasksErrorException("At least one task failed to be added.", failures, notFinished);
        }
    }

    private static class WorkingThread
    implements Runnable {
        static final int MAX_TASKS_PER_REQUEST = 100;
        private static final AtomicInteger CURRENT_MAX_TASKS = new AtomicInteger(100);
        private final TaskSubmitter taskSubmitter;
        private final String jobId;
        private final Queue<BatchTaskCreateParameters> pendingList;
        private final List<BatchTaskCreateResult> failures;
        private volatile Exception exception;
        private final Object lock;
        private final AtomicInteger activeThreadCounter;

        WorkingThread(TaskSubmitter taskSubmitter, String jobId, Queue<BatchTaskCreateParameters> pendingList, List<BatchTaskCreateResult> failures, Object lock, AtomicInteger activeThreadCounter) {
            this.taskSubmitter = taskSubmitter;
            this.jobId = jobId;
            this.pendingList = pendingList;
            this.failures = failures;
            this.exception = null;
            this.lock = lock;
            this.activeThreadCounter = activeThreadCounter;
        }

        public Exception getException() {
            return this.exception;
        }

        private void submitChunk(List<BatchTaskCreateParameters> taskList) {
            try {
                HashMap<String, BatchTaskCreateParameters> taskIdMap = new HashMap<String, BatchTaskCreateParameters>(taskList.size());
                for (BatchTaskCreateParameters p : taskList) {
                    taskIdMap.putIfAbsent(p.getId(), p);
                }
                BatchCreateTaskCollectionResult response = this.taskSubmitter.submitTasks(this.jobId, new BatchTaskGroup(taskList));
                if (response != null && response.getValues() != null) {
                    for (BatchTaskCreateResult result : response.getValues()) {
                        BatchError err;
                        String code;
                        if (result.getError() == null) continue;
                        if (result.getStatus() == BatchTaskAddStatus.SERVER_ERROR) {
                            BatchTaskCreateParameters p;
                            String id = result.getTaskId();
                            if (id == null || (p = (BatchTaskCreateParameters)taskIdMap.get(id)) == null) continue;
                            this.pendingList.add(p);
                            continue;
                        }
                        if (result.getStatus() != BatchTaskAddStatus.CLIENT_ERROR || "TaskExists".equalsIgnoreCase(code = (err = result.getError()) != null ? err.getCode() : null)) continue;
                        this.failures.add(result);
                    }
                }
            }
            catch (BatchErrorException e) {
                this.handleBatchException(e, taskList);
            }
            catch (RuntimeException e) {
                this.exception = e;
                this.pendingList.addAll(taskList);
            }
            catch (Exception e) {
                this.exception = e;
                this.pendingList.addAll(taskList);
            }
        }

        private void handleBatchException(BatchErrorException e, List<BatchTaskCreateParameters> taskList) {
            if (e.getResponse() != null && e.getResponse().getStatusCode() == 413 && taskList.size() > 1) {
                int midpoint = taskList.size() / 2;
                int max = CURRENT_MAX_TASKS.get();
                while (midpoint < max) {
                    CURRENT_MAX_TASKS.compareAndSet(max, midpoint);
                    max = CURRENT_MAX_TASKS.get();
                }
                this.pendingList.addAll(taskList.subList(midpoint, taskList.size()));
                this.submitChunk(taskList.subList(0, midpoint));
            } else {
                this.exception = e;
                this.pendingList.addAll(taskList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BatchTaskCreateParameters param;
                LinkedList<BatchTaskCreateParameters> taskList = new LinkedList<BatchTaskCreateParameters>();
                int maxAmount = CURRENT_MAX_TASKS.get();
                for (int count = 0; count < maxAmount && (param = this.pendingList.poll()) != null; ++count) {
                    taskList.add(param);
                }
                if (!taskList.isEmpty()) {
                    this.submitChunk(taskList);
                }
            }
            finally {
                this.activeThreadCounter.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }
    }
}

