/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchPool;
import com.azure.compute.batch.models.BatchPoolState;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class PoolDeletePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String poolId;
    private final RequestOptions options;
    private final Context requestContext;

    public PoolDeletePollerAsync(BatchAsyncClient batchAsyncClient, String poolId, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.poolId = poolId;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchPool>, Mono<PollResponse<BatchPool>>> getActivationOperation() {
        return context -> this.batchAsyncClient.deletePoolWithResponse(this.poolId, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchPool>, Mono<PollResponse<BatchPool>>> getPollOperation() {
        return context -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getPoolWithResponse(this.poolId, pollOptions).map(response -> {
                BatchPool pool = (BatchPool)((BinaryData)response.getValue()).toObject(BatchPool.class);
                LongRunningOperationStatus status = BatchPoolState.DELETING.equals((Object)pool.getState()) ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return new PollResponse(status, (Object)pool);
            }).onErrorResume(HttpResponseException.class, ex -> ex.getResponse() != null && ex.getResponse().getStatusCode() == 404 ? Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null)) : Mono.error((Throwable)ex));
        };
    }

    public BiFunction<PollingContext<BatchPool>, PollResponse<BatchPool>, Mono<BatchPool>> getCancelOperation() {
        return (context, pollResponse) -> Mono.empty();
    }

    public Function<PollingContext<BatchPool>, Mono<Void>> getFetchResultOperation() {
        return context -> Mono.empty();
    }
}

