/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeState;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class NodeStartPollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String poolId;
    private final String nodeId;
    private final RequestOptions options;
    private final Context requestContext;

    public NodeStartPollerAsync(BatchAsyncClient batchAsyncClient, String poolId, String nodeId, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.poolId = poolId;
        this.nodeId = nodeId;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchNode>, Mono<PollResponse<BatchNode>>> getActivationOperation() {
        return ctx -> this.batchAsyncClient.startNodeWithResponse(this.poolId, this.nodeId, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchNode>, Mono<PollResponse<BatchNode>>> getPollOperation() {
        return ctx -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getNodeWithResponse(this.poolId, this.nodeId, pollOptions).flatMap(resp -> {
                BatchNode node = (BatchNode)((BinaryData)resp.getValue()).toObject(BatchNode.class);
                BatchNodeState state = node.getState();
                LongRunningOperationStatus status = state == BatchNodeState.STARTING ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return Mono.just((Object)new PollResponse(status, (Object)node));
            });
        };
    }

    public BiFunction<PollingContext<BatchNode>, PollResponse<BatchNode>, Mono<BatchNode>> getCancelOperation() {
        return (ctx, resp) -> Mono.empty();
    }

    public Function<PollingContext<BatchNode>, Mono<BatchNode>> getFetchResultOperation() {
        return ctx -> Mono.justOrEmpty((Object)((BatchNode)ctx.getLatestResponse().getValue()));
    }
}

