/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.AllocationState;
import com.azure.compute.batch.models.BatchNodeRemoveParameters;
import com.azure.compute.batch.models.BatchPool;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class NodeRemovePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String poolId;
    private final BatchNodeRemoveParameters parameters;
    private final RequestOptions options;
    private final Context requestContext;

    public NodeRemovePollerAsync(BatchAsyncClient client, String poolId, BatchNodeRemoveParameters parameters, RequestOptions options) {
        this.batchAsyncClient = client;
        this.poolId = poolId;
        this.parameters = parameters;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchPool>, Mono<PollResponse<BatchPool>>> getActivationOperation() {
        return ctx -> this.batchAsyncClient.removeNodesWithResponse(this.poolId, BinaryData.fromObject((Object)this.parameters), this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchPool>, Mono<PollResponse<BatchPool>>> getPollOperation() {
        return ctx -> {
            RequestOptions pollOpts = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getPoolWithResponse(this.poolId, pollOpts).flatMap(resp -> {
                BatchPool pool = (BatchPool)((BinaryData)resp.getValue()).toObject(BatchPool.class);
                AllocationState aState = pool.getAllocationState();
                LongRunningOperationStatus status = aState == AllocationState.STEADY ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : LongRunningOperationStatus.IN_PROGRESS;
                return Mono.just((Object)new PollResponse(status, (Object)pool));
            }).onErrorResume(HttpResponseException.class, ex -> ex.getResponse() != null && ex.getResponse().getStatusCode() == 404 ? Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null)) : Mono.error((Throwable)ex));
        };
    }

    public BiFunction<PollingContext<BatchPool>, PollResponse<BatchPool>, Mono<BatchPool>> getCancelOperation() {
        return (ctx, resp) -> Mono.empty();
    }

    public Function<PollingContext<BatchPool>, Mono<BatchPool>> getFetchResultOperation() {
        return ctx -> Mono.justOrEmpty((Object)((BatchPool)ctx.getLatestResponse().getValue()));
    }
}

