/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeState;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class NodeReimagePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String poolId;
    private final String nodeId;
    private final RequestOptions options;
    private final Context requestContext;

    public NodeReimagePollerAsync(BatchAsyncClient batchAsyncClient, String poolId, String nodeId, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.poolId = poolId;
        this.nodeId = nodeId;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchNode>, Mono<PollResponse<BatchNode>>> getActivationOperation() {
        return ctx -> this.batchAsyncClient.reimageNodeWithResponse(this.poolId, this.nodeId, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchNode>, Mono<PollResponse<BatchNode>>> getPollOperation() {
        return ctx -> {
            RequestOptions pollOpts = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getNodeWithResponse(this.poolId, this.nodeId, pollOpts).map(resp -> {
                BatchNode node = (BatchNode)((BinaryData)resp.getValue()).toObject(BatchNode.class);
                LongRunningOperationStatus status = node.getState() == BatchNodeState.REIMAGING ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return new PollResponse(status, (Object)node);
            });
        };
    }

    public BiFunction<PollingContext<BatchNode>, PollResponse<BatchNode>, Mono<BatchNode>> getCancelOperation() {
        return (ctx, resp) -> Mono.empty();
    }

    public Function<PollingContext<BatchNode>, Mono<BatchNode>> getFetchResultOperation() {
        return ctx -> Mono.justOrEmpty((Object)((BatchNode)ctx.getLatestResponse().getValue()));
    }
}

