/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchJobSchedule;
import com.azure.compute.batch.models.BatchJobScheduleState;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class JobScheduleTerminatePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String jobScheduleId;
    private final RequestOptions options;
    private final Context requestContext;

    public JobScheduleTerminatePollerAsync(BatchAsyncClient batchAsyncClient, String jobScheduleId, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.jobScheduleId = jobScheduleId;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchJobSchedule>, Mono<PollResponse<BatchJobSchedule>>> getActivationOperation() {
        return context -> this.batchAsyncClient.terminateJobScheduleWithResponse(this.jobScheduleId, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchJobSchedule>, Mono<PollResponse<BatchJobSchedule>>> getPollOperation() {
        return context -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobScheduleWithResponse(this.jobScheduleId, pollOptions).map(response -> {
                BatchJobSchedule jobSchedule = (BatchJobSchedule)((BinaryData)response.getValue()).toObject(BatchJobSchedule.class);
                BatchJobScheduleState state = jobSchedule.getState();
                LongRunningOperationStatus status = BatchJobScheduleState.TERMINATING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return new PollResponse(status, (Object)jobSchedule);
            }).onErrorResume(HttpResponseException.class, ex -> ex.getResponse() != null && ex.getResponse().getStatusCode() == 404 ? Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null)) : Mono.error((Throwable)ex));
        };
    }

    public BiFunction<PollingContext<BatchJobSchedule>, PollResponse<BatchJobSchedule>, Mono<BatchJobSchedule>> getCancelOperation() {
        return (context, pollResponse) -> Mono.empty();
    }

    public Function<PollingContext<BatchJobSchedule>, Mono<BatchJobSchedule>> getFetchResultOperation() {
        return context -> {
            RequestOptions fetchOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobScheduleWithResponse(this.jobScheduleId, fetchOptions).map(response -> (BatchJobSchedule)((BinaryData)response.getValue()).toObject(BatchJobSchedule.class));
        };
    }
}

