/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobState;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class JobEnablePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String jobId;
    private final RequestOptions options;
    private final Context requestContext;

    public JobEnablePollerAsync(BatchAsyncClient batchAsyncClient, String jobId, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.jobId = jobId;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchJob>, Mono<PollResponse<BatchJob>>> getActivationOperation() {
        return context -> this.batchAsyncClient.enableJobWithResponse(this.jobId, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchJob>, Mono<PollResponse<BatchJob>>> getPollOperation() {
        return context -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobWithResponse(this.jobId, pollOptions).map(response -> {
                BatchJob job = (BatchJob)((BinaryData)response.getValue()).toObject(BatchJob.class);
                LongRunningOperationStatus status = BatchJobState.ENABLING.equals((Object)job.getState()) ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return new PollResponse(status, (Object)job);
            });
        };
    }

    public BiFunction<PollingContext<BatchJob>, PollResponse<BatchJob>, Mono<BatchJob>> getCancelOperation() {
        return (context, pollResponse) -> Mono.empty();
    }

    public Function<PollingContext<BatchJob>, Mono<BatchJob>> getFetchResultOperation() {
        return context -> {
            RequestOptions resultOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobWithResponse(this.jobId, resultOptions).map(response -> (BatchJob)((BinaryData)response.getValue()).toObject(BatchJob.class));
        };
    }
}

