/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobDisableParameters;
import com.azure.compute.batch.models.BatchJobState;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class JobDisablePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String jobId;
    private final BatchJobDisableParameters parameters;
    private final RequestOptions options;
    private final Context requestContext;

    public JobDisablePollerAsync(BatchAsyncClient batchAsyncClient, String jobId, BatchJobDisableParameters parameters, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.jobId = jobId;
        this.parameters = parameters;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchJob>, Mono<PollResponse<BatchJob>>> getActivationOperation() {
        return context -> this.batchAsyncClient.disableJobWithResponse(this.jobId, BinaryData.fromObject((Object)this.parameters), this.options).then(this.batchAsyncClient.getJobWithResponse(this.jobId, null)).map(response -> {
            BatchJob job = (BatchJob)((BinaryData)response.getValue()).toObject(BatchJob.class);
            return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)job);
        });
    }

    public Function<PollingContext<BatchJob>, Mono<PollResponse<BatchJob>>> getPollOperation() {
        return context -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobWithResponse(this.jobId, pollOptions).map(response -> {
                BatchJob job = (BatchJob)((BinaryData)response.getValue()).toObject(BatchJob.class);
                BatchJobState state = job.getState();
                LongRunningOperationStatus status = BatchJobState.DISABLING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                return new PollResponse(status, (Object)job);
            });
        };
    }

    public BiFunction<PollingContext<BatchJob>, PollResponse<BatchJob>, Mono<BatchJob>> getCancelOperation() {
        return (context, pollResponse) -> Mono.empty();
    }

    public Function<PollingContext<BatchJob>, Mono<BatchJob>> getFetchResultOperation() {
        return context -> {
            RequestOptions fetchOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getJobWithResponse(this.jobId, fetchOptions).map(response -> (BatchJob)((BinaryData)response.getValue()).toObject(BatchJob.class));
        };
    }
}

