/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.models.BatchCertificate;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class CertificateDeletePollerAsync {
    private final BatchAsyncClient batchAsyncClient;
    private final String thumbprintAlgorithm;
    private final String thumbprint;
    private final RequestOptions options;
    private final Context requestContext;

    public CertificateDeletePollerAsync(BatchAsyncClient batchAsyncClient, String thumbprintAlgorithm, String thumbprint, RequestOptions options) {
        this.batchAsyncClient = batchAsyncClient;
        this.thumbprintAlgorithm = thumbprintAlgorithm;
        this.thumbprint = thumbprint;
        this.options = options;
        this.requestContext = options == null ? Context.NONE : options.getContext();
    }

    public Function<PollingContext<BatchCertificate>, Mono<PollResponse<BatchCertificate>>> getActivationOperation() {
        return context -> this.batchAsyncClient.deleteCertificateWithResponse(this.thumbprintAlgorithm, this.thumbprint, this.options).thenReturn((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null));
    }

    public Function<PollingContext<BatchCertificate>, Mono<PollResponse<BatchCertificate>>> getPollOperation() {
        return context -> {
            RequestOptions pollOptions = new RequestOptions().setContext(this.requestContext);
            return this.batchAsyncClient.getCertificateWithResponse(this.thumbprintAlgorithm, this.thumbprint, pollOptions).map(response -> {
                BatchCertificate cert = (BatchCertificate)((BinaryData)response.getValue()).toObject(BatchCertificate.class);
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)cert);
            }).onErrorResume(HttpResponseException.class, ex -> ex.getResponse() != null && ex.getResponse().getStatusCode() == 404 ? Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null)) : Mono.error((Throwable)ex));
        };
    }

    public BiFunction<PollingContext<BatchCertificate>, PollResponse<BatchCertificate>, Mono<BatchCertificate>> getCancelOperation() {
        return (context, pollResponse) -> Mono.empty();
    }

    public Function<PollingContext<BatchCertificate>, Mono<Void>> getFetchResultOperation() {
        return context -> Mono.empty();
    }
}

