/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchAsyncClient;
import com.azure.compute.batch.BatchClientBuilder;
import com.azure.compute.batch.implementation.BatchClientImpl;
import com.azure.compute.batch.implementation.task.SyncClientTaskSubmitter;
import com.azure.compute.batch.implementation.task.TaskManager;
import com.azure.compute.batch.models.AutoScaleRun;
import com.azure.compute.batch.models.BatchApplication;
import com.azure.compute.batch.models.BatchApplicationGetOptions;
import com.azure.compute.batch.models.BatchApplicationsListOptions;
import com.azure.compute.batch.models.BatchCertificate;
import com.azure.compute.batch.models.BatchCertificateCancelDeletionOptions;
import com.azure.compute.batch.models.BatchCertificateCreateOptions;
import com.azure.compute.batch.models.BatchCertificateDeleteOptions;
import com.azure.compute.batch.models.BatchCertificateGetOptions;
import com.azure.compute.batch.models.BatchCertificatesListOptions;
import com.azure.compute.batch.models.BatchCreateTaskCollectionResult;
import com.azure.compute.batch.models.BatchFileProperties;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobCreateOptions;
import com.azure.compute.batch.models.BatchJobCreateParameters;
import com.azure.compute.batch.models.BatchJobDeleteOptions;
import com.azure.compute.batch.models.BatchJobDisableOptions;
import com.azure.compute.batch.models.BatchJobDisableParameters;
import com.azure.compute.batch.models.BatchJobEnableOptions;
import com.azure.compute.batch.models.BatchJobGetOptions;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatus;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatusListOptions;
import com.azure.compute.batch.models.BatchJobReplaceOptions;
import com.azure.compute.batch.models.BatchJobSchedule;
import com.azure.compute.batch.models.BatchJobScheduleCreateOptions;
import com.azure.compute.batch.models.BatchJobScheduleCreateParameters;
import com.azure.compute.batch.models.BatchJobScheduleDeleteOptions;
import com.azure.compute.batch.models.BatchJobScheduleDisableOptions;
import com.azure.compute.batch.models.BatchJobScheduleEnableOptions;
import com.azure.compute.batch.models.BatchJobScheduleExistsOptions;
import com.azure.compute.batch.models.BatchJobScheduleGetOptions;
import com.azure.compute.batch.models.BatchJobScheduleReplaceOptions;
import com.azure.compute.batch.models.BatchJobScheduleTerminateOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateParameters;
import com.azure.compute.batch.models.BatchJobSchedulesListOptions;
import com.azure.compute.batch.models.BatchJobTaskCountsGetOptions;
import com.azure.compute.batch.models.BatchJobTerminateOptions;
import com.azure.compute.batch.models.BatchJobTerminateParameters;
import com.azure.compute.batch.models.BatchJobUpdateOptions;
import com.azure.compute.batch.models.BatchJobUpdateParameters;
import com.azure.compute.batch.models.BatchJobsFromScheduleListOptions;
import com.azure.compute.batch.models.BatchJobsListOptions;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeDeallocateOptions;
import com.azure.compute.batch.models.BatchNodeDeallocateParameters;
import com.azure.compute.batch.models.BatchNodeDisableSchedulingParameters;
import com.azure.compute.batch.models.BatchNodeExtensionGetOptions;
import com.azure.compute.batch.models.BatchNodeExtensionsListOptions;
import com.azure.compute.batch.models.BatchNodeFile;
import com.azure.compute.batch.models.BatchNodeFileDeleteOptions;
import com.azure.compute.batch.models.BatchNodeFileGetOptions;
import com.azure.compute.batch.models.BatchNodeFilePropertiesGetOptions;
import com.azure.compute.batch.models.BatchNodeFilesListOptions;
import com.azure.compute.batch.models.BatchNodeGetOptions;
import com.azure.compute.batch.models.BatchNodeLogsUploadOptions;
import com.azure.compute.batch.models.BatchNodeRebootOptions;
import com.azure.compute.batch.models.BatchNodeRebootParameters;
import com.azure.compute.batch.models.BatchNodeReimageOptions;
import com.azure.compute.batch.models.BatchNodeReimageParameters;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettings;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettingsGetOptions;
import com.azure.compute.batch.models.BatchNodeRemoveParameters;
import com.azure.compute.batch.models.BatchNodeSchedulingDisableOptions;
import com.azure.compute.batch.models.BatchNodeSchedulingEnableOptions;
import com.azure.compute.batch.models.BatchNodeStartOptions;
import com.azure.compute.batch.models.BatchNodeUserCreateOptions;
import com.azure.compute.batch.models.BatchNodeUserCreateParameters;
import com.azure.compute.batch.models.BatchNodeUserDeleteOptions;
import com.azure.compute.batch.models.BatchNodeUserReplaceOptions;
import com.azure.compute.batch.models.BatchNodeUserUpdateParameters;
import com.azure.compute.batch.models.BatchNodeVMExtension;
import com.azure.compute.batch.models.BatchNodesListOptions;
import com.azure.compute.batch.models.BatchNodesRemoveOptions;
import com.azure.compute.batch.models.BatchPool;
import com.azure.compute.batch.models.BatchPoolCreateOptions;
import com.azure.compute.batch.models.BatchPoolCreateParameters;
import com.azure.compute.batch.models.BatchPoolDeleteOptions;
import com.azure.compute.batch.models.BatchPoolDisableAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleParameters;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleParameters;
import com.azure.compute.batch.models.BatchPoolExistsOptions;
import com.azure.compute.batch.models.BatchPoolGetOptions;
import com.azure.compute.batch.models.BatchPoolNodeCounts;
import com.azure.compute.batch.models.BatchPoolNodeCountsListOptions;
import com.azure.compute.batch.models.BatchPoolPropertiesReplaceOptions;
import com.azure.compute.batch.models.BatchPoolReplaceParameters;
import com.azure.compute.batch.models.BatchPoolResizeOptions;
import com.azure.compute.batch.models.BatchPoolResizeParameters;
import com.azure.compute.batch.models.BatchPoolResizeStopOptions;
import com.azure.compute.batch.models.BatchPoolUpdateOptions;
import com.azure.compute.batch.models.BatchPoolUpdateParameters;
import com.azure.compute.batch.models.BatchPoolUsageMetrics;
import com.azure.compute.batch.models.BatchPoolUsageMetricsListOptions;
import com.azure.compute.batch.models.BatchPoolsListOptions;
import com.azure.compute.batch.models.BatchSubTasksListOptions;
import com.azure.compute.batch.models.BatchSubtask;
import com.azure.compute.batch.models.BatchSupportedImage;
import com.azure.compute.batch.models.BatchTask;
import com.azure.compute.batch.models.BatchTaskBulkCreateOptions;
import com.azure.compute.batch.models.BatchTaskCollectionCreateOptions;
import com.azure.compute.batch.models.BatchTaskCountsResult;
import com.azure.compute.batch.models.BatchTaskCreateOptions;
import com.azure.compute.batch.models.BatchTaskCreateParameters;
import com.azure.compute.batch.models.BatchTaskDeleteOptions;
import com.azure.compute.batch.models.BatchTaskFileDeleteOptions;
import com.azure.compute.batch.models.BatchTaskFileGetOptions;
import com.azure.compute.batch.models.BatchTaskFilePropertiesGetOptions;
import com.azure.compute.batch.models.BatchTaskFilesListOptions;
import com.azure.compute.batch.models.BatchTaskGetOptions;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.BatchTaskReactivateOptions;
import com.azure.compute.batch.models.BatchTaskReplaceOptions;
import com.azure.compute.batch.models.BatchTaskTerminateOptions;
import com.azure.compute.batch.models.BatchTasksListOptions;
import com.azure.compute.batch.models.SupportedBatchImagesListOptions;
import com.azure.compute.batch.models.UploadBatchServiceLogsParameters;
import com.azure.compute.batch.models.UploadBatchServiceLogsResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=BatchClientBuilder.class)
public final class BatchClient {
    private final BatchClientImpl serviceClient;
    private final BatchAsyncClient asyncClient;

    BatchClient(BatchClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.asyncClient = new BatchAsyncClient(this.serviceClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTasks(String jobId, Collection<BatchTaskCreateParameters> taskList) {
        this.createTasks(jobId, taskList, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTasks(String jobId, Collection<BatchTaskCreateParameters> taskList, BatchTaskBulkCreateOptions batchTaskBulkCreateOptions) {
        SyncClientTaskSubmitter taskSubmitter = new SyncClientTaskSubmitter(this);
        TaskManager.createTasks(taskSubmitter, jobId, taskList, batchTaskBulkCreateOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listApplications(RequestOptions requestOptions) {
        return this.serviceClient.listApplications(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getApplicationWithResponse(String applicationId, RequestOptions requestOptions) {
        return this.serviceClient.getApplicationWithResponse(applicationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolUsageMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listPoolUsageMetrics(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createPoolWithResponse(BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.createPoolWithResponse(pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPools(RequestOptions requestOptions) {
        return this.serviceClient.listPools(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> deletePoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.deletePoolWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> poolExistsWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.poolExistsWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getPoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePoolWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.updatePoolWithResponse(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disablePoolAutoScaleWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.disablePoolAutoScaleWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enablePoolAutoScaleWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.enablePoolAutoScaleWithResponse(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> evaluatePoolAutoScaleWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.evaluatePoolAutoScaleWithResponse(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> resizePoolWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.resizePoolWithResponse(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> stopPoolResizeWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.stopPoolResizeWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replacePoolPropertiesWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.replacePoolPropertiesWithResponse(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> removeNodesWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.removeNodesWithResponse(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSupportedImages(RequestOptions requestOptions) {
        return this.serviceClient.listSupportedImages(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolNodeCounts(RequestOptions requestOptions) {
        return this.serviceClient.listPoolNodeCounts(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> deleteJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.updateJobWithResponse(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobWithResponse(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> disableJobWithResponse(String jobId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.disableJobWithResponse(jobId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> enableJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> terminateJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobWithResponse(BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.createJobWithResponse(job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobs(RequestOptions requestOptions) {
        return this.serviceClient.listJobs(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobsFromSchedule(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobPreparationAndReleaseTaskStatus(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobTaskCountsWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobTaskCountsWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createCertificateWithResponse(BinaryData certificate, RequestOptions requestOptions) {
        return this.serviceClient.createCertificateWithResponse(certificate, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCertificates(RequestOptions requestOptions) {
        return this.serviceClient.listCertificates(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelCertificateDeletionWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> deleteCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> jobScheduleExistsWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.jobScheduleExistsWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> deleteJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.getJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.updateJobScheduleWithResponse(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobScheduleWithResponse(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.disableJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> terminateJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobScheduleWithResponse(BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.createJobScheduleWithResponse(jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobSchedules(RequestOptions requestOptions) {
        return this.serviceClient.listJobSchedules(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createTaskWithResponse(String jobId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.createTaskWithResponse(jobId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTasks(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listTasks(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createTaskCollectionWithResponse(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        return this.serviceClient.createTaskCollectionWithResponse(jobId, taskCollection, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.getTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceTaskWithResponse(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.replaceTaskWithResponse(jobId, taskId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSubTasks(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.terminateTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reactivateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.reactivateTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getTaskFilePropertiesWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTaskFiles(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNodeUserWithResponse(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        return this.serviceClient.createNodeUserWithResponse(poolId, nodeId, user, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeUserWithResponse(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceNodeUserWithResponse(String poolId, String nodeId, String userName, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.replaceNodeUserWithResponse(poolId, nodeId, userName, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> rebootNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.rebootNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> startNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.startNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> reimageNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.reimageNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<Void> deallocateNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.deallocateNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeRemoteLoginSettingsWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> uploadNodeLogsWithResponse(String poolId, String nodeId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.uploadNodeLogsWithResponse(poolId, nodeId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodes(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.listNodes(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeExtensionWithResponse(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        return this.serviceClient.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeExtensions(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getNodeFilePropertiesWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeFiles(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchApplication> listApplications() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listApplications(requestOptions).mapPage(bodyItemValue -> (BatchApplication)bodyItemValue.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchApplication getApplication(String applicationId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchApplication)((BinaryData)this.getApplicationWithResponse(applicationId, requestOptions).getValue()).toObject(BatchApplication.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolUsageMetrics> listPoolUsageMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPoolUsageMetrics(requestOptions).mapPage(bodyItemValue -> (BatchPoolUsageMetrics)bodyItemValue.toObject(BatchPoolUsageMetrics.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPool> listPools() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPools(requestOptions).mapPage(bodyItemValue -> (BatchPool)bodyItemValue.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deletePool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deletePoolWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, Void> beginDeletePool(String poolId) {
        PollerFlux<BatchPool, Void> asyncPoller = this.asyncClient.beginDeletePool(poolId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean poolExists(String poolId, BatchPoolExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (Boolean)this.poolExistsWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean poolExists(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Boolean)this.poolExistsWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchPool getPool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchPool)((BinaryData)this.getPoolWithResponse(poolId, requestOptions).getValue()).toObject(BatchPool.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disablePoolAutoScale(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disablePoolAutoScaleWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void stopPoolResize(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.stopPoolResizeWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, BatchPool> beginStopPoolResize(String poolId) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginStopPoolResize(poolId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSupportedImage> listSupportedImages() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listSupportedImages(requestOptions).mapPage(bodyItemValue -> (BatchSupportedImage)bodyItemValue.toObject(BatchSupportedImage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolNodeCounts> listPoolNodeCounts() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPoolNodeCounts(requestOptions).mapPage(bodyItemValue -> (BatchPoolNodeCounts)bodyItemValue.toObject(BatchPoolNodeCounts.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, Void> beginDeleteJob(String jobId) {
        PollerFlux<BatchJob, Void> asyncPoller = this.asyncClient.beginDeleteJob(jobId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJob getJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchJob)((BinaryData)this.getJobWithResponse(jobId, requestOptions).getValue()).toObject(BatchJob.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJob(String jobId, BatchJob job) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void enableJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginEnableJob(String jobId) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginEnableJob(jobId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void terminateJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginTerminateJob(String jobId) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginTerminateJob(jobId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobs() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobs(requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobsFromSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions).mapPage(bodyItemValue -> (BatchJobPreparationAndReleaseTaskStatus)bodyItemValue.toObject(BatchJobPreparationAndReleaseTaskStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskCountsResult getJobTaskCounts(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchTaskCountsResult)((BinaryData)this.getJobTaskCountsWithResponse(jobId, requestOptions).getValue()).toObject(BatchTaskCountsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createCertificate(BatchCertificate certificate) {
        RequestOptions requestOptions = new RequestOptions();
        this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchCertificate> listCertificates() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listCertificates(requestOptions).mapPage(bodyItemValue -> (BatchCertificate)bodyItemValue.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<BatchCertificate, Void> beginDeleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        PollerFlux<BatchCertificate, Void> asyncPoller = this.asyncClient.beginDeleteCertificate(thumbprintAlgorithm, thumbprint);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchCertificate getCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchCertificate)((BinaryData)this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue()).toObject(BatchCertificate.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean jobScheduleExists(String jobScheduleId, BatchJobScheduleExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (Boolean)this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean jobScheduleExists(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Boolean)this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJobSchedule, Void> beginDeleteJobSchedule(String jobScheduleId) {
        PollerFlux<BatchJobSchedule, Void> asyncPoller = this.asyncClient.beginDeleteJobSchedule(jobScheduleId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJobSchedule getJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchJobSchedule)((BinaryData)this.getJobScheduleWithResponse(jobScheduleId, requestOptions).getValue()).toObject(BatchJobSchedule.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void terminateJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJobSchedule, BatchJobSchedule> beginTerminateJobSchedule(String jobScheduleId) {
        PollerFlux<BatchJobSchedule, BatchJobSchedule> asyncPoller = this.asyncClient.beginTerminateJobSchedule(jobScheduleId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobSchedule> listJobSchedules() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobSchedules(requestOptions).mapPage(bodyItemValue -> (BatchJobSchedule)bodyItemValue.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchTask> listTasks(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTasks(jobId, requestOptions).mapPage(bodyItemValue -> (BatchTask)bodyItemValue.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchCreateTaskCollectionResult createTaskCollection(String jobId, BatchTaskGroup taskCollection) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchCreateTaskCollectionResult)((BinaryData)this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).getValue()).toObject(BatchCreateTaskCollectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTask getTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchTask)((BinaryData)this.getTaskWithResponse(jobId, taskId, requestOptions).getValue()).toObject(BatchTask.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceTask(String jobId, String taskId, BatchTask task) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSubtask> listSubTasks(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchSubtask)bodyItemValue.toObject(BatchSubtask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reactivateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.reactivateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchFileProperties getTaskFileProperties(String jobId, String taskId, String filePath, BatchTaskFilePropertiesGetOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        Response<Void> response = this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions);
        return new BatchFileProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchFileProperties getTaskFileProperties(String jobId, String taskId, String filePath) {
        Response<Void> response = this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, new RequestOptions());
        return new BatchFileProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listTaskFiles(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeUser(String poolId, String nodeId, String userName) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNode getNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNode)((BinaryData)this.getNodeWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNode.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void rebootNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.rebootNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginRebootNode(String poolId, String nodeId) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginRebootNode(poolId, nodeId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void startNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.startNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginStartNode(String poolId, String nodeId) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginStartNode(poolId, nodeId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void reimageNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.reimageNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginReimageNode(String poolId, String nodeId) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginReimageNode(poolId, nodeId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deallocateNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginDeallocateNode(String poolId, String nodeId) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginDeallocateNode(poolId, nodeId);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeRemoteLoginSettings getNodeRemoteLoginSettings(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNodeRemoteLoginSettings)((BinaryData)this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNodeRemoteLoginSettings.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNode> listNodes(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodes(poolId, requestOptions).mapPage(bodyItemValue -> (BatchNode)bodyItemValue.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeVMExtension getNodeExtension(String poolId, String nodeId, String extensionName) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNodeVMExtension)((BinaryData)this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).getValue()).toObject(BatchNodeVMExtension.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeVMExtension)bodyItemValue.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchFileProperties getNodeFileProperties(String poolId, String nodeId, String filePath, BatchNodeFilePropertiesGetOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        Response<Void> response = this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions);
        return new BatchFileProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchFileProperties getNodeFileProperties(String poolId, String nodeId, String filePath) {
        Response<Void> response = this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, new RequestOptions());
        return new BatchFileProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listNodeFiles(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchApplication> listApplications(BatchApplicationsListOptions options) {
        Integer maxPageSize;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer n = maxPageSize = options == null ? null : options.getMaxPageSize();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        return this.serviceClient.listApplications(requestOptions).mapPage(bodyItemValue -> (BatchApplication)bodyItemValue.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchApplication getApplication(String applicationId, BatchApplicationGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (BatchApplication)((BinaryData)this.getApplicationWithResponse(applicationId, requestOptions).getValue()).toObject(BatchApplication.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolUsageMetrics> listPoolUsageMetrics(BatchPoolUsageMetricsListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        OffsetDateTime startTime = options == null ? null : options.getStartTime();
        OffsetDateTime endtime = options == null ? null : options.getEndtime();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (startTime != null) {
            requestOptions.addQueryParam("startTime", String.valueOf(startTime), false);
        }
        if (endtime != null) {
            requestOptions.addQueryParam("endtime", String.valueOf(endtime), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listPoolUsageMetrics(requestOptions).mapPage(bodyItemValue -> (BatchPoolUsageMetrics)bodyItemValue.toObject(BatchPoolUsageMetrics.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPool> listPools(BatchPoolsListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listPools(requestOptions).mapPage(bodyItemValue -> (BatchPool)bodyItemValue.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deletePool(String poolId, BatchPoolDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deletePoolWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, Void> beginDeletePool(String poolId, BatchPoolDeleteOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchPool, Void> asyncPoller = this.asyncClient.beginDeletePool(poolId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchPool getPool(String poolId, BatchPoolGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchPool)((BinaryData)this.getPoolWithResponse(poolId, requestOptions).getValue()).toObject(BatchPool.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void stopPoolResize(String poolId, BatchPoolResizeStopOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.stopPoolResizeWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, BatchPool> beginStopPoolResize(String poolId, BatchPoolResizeStopOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginStopPoolResize(poolId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSupportedImage> listSupportedImages(SupportedBatchImagesListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listSupportedImages(requestOptions).mapPage(bodyItemValue -> (BatchSupportedImage)bodyItemValue.toObject(BatchSupportedImage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolNodeCounts> listPoolNodeCounts(BatchPoolNodeCountsListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listPoolNodeCounts(requestOptions).mapPage(bodyItemValue -> (BatchPoolNodeCounts)bodyItemValue.toObject(BatchPoolNodeCounts.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteJob(String jobId, BatchJobDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, Void> beginDeleteJob(String jobId, BatchJobDeleteOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJob, Void> asyncPoller = this.asyncClient.beginDeleteJob(jobId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJob getJob(String jobId, BatchJobGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchJob)((BinaryData)this.getJobWithResponse(jobId, requestOptions).getValue()).toObject(BatchJob.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJob(String jobId, BatchJob job, BatchJobReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void enableJob(String jobId, BatchJobEnableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enableJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginEnableJob(String jobId, BatchJobEnableOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginEnableJob(jobId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void terminateJob(String jobId, BatchJobTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchJobTerminateParameters parameters = options == null ? null : options.getParameters();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginTerminateJob(String jobId, BatchJobTerminateOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginTerminateJob(jobId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobs(BatchJobsListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobs(requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobsFromSchedule(String jobScheduleId, BatchJobsFromScheduleListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId, BatchJobPreparationAndReleaseTaskStatusListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions).mapPage(bodyItemValue -> (BatchJobPreparationAndReleaseTaskStatus)bodyItemValue.toObject(BatchJobPreparationAndReleaseTaskStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskCountsResult getJobTaskCounts(String jobId, BatchJobTaskCountsGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (BatchTaskCountsResult)((BinaryData)this.getJobTaskCountsWithResponse(jobId, requestOptions).getValue()).toObject(BatchTaskCountsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createCertificate(BatchCertificate certificate, BatchCertificateCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchCertificate> listCertificates(BatchCertificatesListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listCertificates(requestOptions).mapPage(bodyItemValue -> (BatchCertificate)bodyItemValue.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint, BatchCertificateCancelDeletionOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateDeleteOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchCertificate, Void> beginDeleteCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateDeleteOptions options) {
        PollerFlux<BatchCertificate, Void> asyncPoller = this.asyncClient.beginDeleteCertificate(thumbprintAlgorithm, thumbprint, options);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchCertificate getCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (BatchCertificate)((BinaryData)this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue()).toObject(BatchCertificate.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deleteJobSchedule(String jobScheduleId, BatchJobScheduleDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJobSchedule, Void> beginDeleteJobSchedule(String jobScheduleId, BatchJobScheduleDeleteOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJobSchedule, Void> asyncPoller = this.asyncClient.beginDeleteJobSchedule(jobScheduleId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJobSchedule getJobSchedule(String jobScheduleId, BatchJobScheduleGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchJobSchedule)((BinaryData)this.getJobScheduleWithResponse(jobScheduleId, requestOptions).getValue()).toObject(BatchJobSchedule.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule, BatchJobScheduleReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJobSchedule(String jobScheduleId, BatchJobScheduleDisableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJobSchedule(String jobScheduleId, BatchJobScheduleEnableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void terminateJobSchedule(String jobScheduleId, BatchJobScheduleTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJobSchedule, BatchJobSchedule> beginTerminateJobSchedule(String jobScheduleId, BatchJobScheduleTerminateOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJobSchedule, BatchJobSchedule> asyncPoller = this.asyncClient.beginTerminateJobSchedule(jobScheduleId, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobSchedule> listJobSchedules(BatchJobSchedulesListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobSchedules(requestOptions).mapPage(bodyItemValue -> (BatchJobSchedule)bodyItemValue.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchTask> listTasks(String jobId, BatchTasksListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listTasks(jobId, requestOptions).mapPage(bodyItemValue -> (BatchTask)bodyItemValue.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchCreateTaskCollectionResult createTaskCollection(String jobId, BatchTaskGroup taskCollection, BatchTaskCollectionCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (BatchCreateTaskCollectionResult)((BinaryData)this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).getValue()).toObject(BatchCreateTaskCollectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTask(String jobId, String taskId, BatchTaskDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTask getTask(String jobId, String taskId, BatchTaskGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchTask)((BinaryData)this.getTaskWithResponse(jobId, taskId, requestOptions).getValue()).toObject(BatchTask.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceTask(String jobId, String taskId, BatchTask task, BatchTaskReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSubtask> listSubTasks(String jobId, String taskId, BatchSubTasksListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchSubtask)bodyItemValue.toObject(BatchSubtask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateTask(String jobId, String taskId, BatchTaskTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reactivateTask(String jobId, String taskId, BatchTaskReactivateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.reactivateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTaskFile(String jobId, String taskId, String filePath, BatchTaskFileDeleteOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getTaskFile(String jobId, String taskId, String filePath, BatchTaskFileGetOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return (BinaryData)this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listTaskFiles(String jobId, String taskId, BatchTaskFilesListOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeUser(String poolId, String nodeId, String userName, BatchNodeUserDeleteOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNode getNode(String poolId, String nodeId, BatchNodeGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (BatchNode)((BinaryData)this.getNodeWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNode.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void rebootNode(String poolId, String nodeId, BatchNodeRebootOptions options) {
        BatchNodeRebootParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeRebootParameters batchNodeRebootParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.rebootNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginRebootNode(String poolId, String nodeId, BatchNodeRebootOptions options) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginRebootNode(poolId, nodeId, options);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void startNode(String poolId, String nodeId, BatchNodeStartOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.startNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginStartNode(String poolId, String nodeId, BatchNodeStartOptions options) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginStartNode(poolId, nodeId, options);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void reimageNode(String poolId, String nodeId, BatchNodeReimageOptions options) {
        BatchNodeReimageParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeReimageParameters batchNodeReimageParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.reimageNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginReimageNode(String poolId, String nodeId, BatchNodeReimageOptions options) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginReimageNode(poolId, nodeId, options);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void deallocateNode(String poolId, String nodeId, BatchNodeDeallocateOptions options) {
        BatchNodeDeallocateParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDeallocateParameters batchNodeDeallocateParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchNode, BatchNode> beginDeallocateNode(String poolId, String nodeId, BatchNodeDeallocateOptions options) {
        PollerFlux<BatchNode, BatchNode> asyncPoller = this.asyncClient.beginDeallocateNode(poolId, nodeId, options);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableNodeScheduling(String poolId, String nodeId, BatchNodeSchedulingDisableOptions options) {
        BatchNodeDisableSchedulingParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDisableSchedulingParameters batchNodeDisableSchedulingParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableNodeScheduling(String poolId, String nodeId, BatchNodeSchedulingEnableOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeRemoteLoginSettings getNodeRemoteLoginSettings(String poolId, String nodeId, BatchNodeRemoteLoginSettingsGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (BatchNodeRemoteLoginSettings)((BinaryData)this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNodeRemoteLoginSettings.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNode> listNodes(String poolId, BatchNodesListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listNodes(poolId, requestOptions).mapPage(bodyItemValue -> (BatchNode)bodyItemValue.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeVMExtension getNodeExtension(String poolId, String nodeId, String extensionName, BatchNodeExtensionGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (BatchNodeVMExtension)((BinaryData)this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).getValue()).toObject(BatchNodeVMExtension.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId, BatchNodeExtensionsListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeVMExtension)bodyItemValue.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeFile(String poolId, String nodeId, String filePath, BatchNodeFileDeleteOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getNodeFile(String poolId, String nodeId, String filePath, BatchNodeFileGetOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return (BinaryData)this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listNodeFiles(String poolId, String nodeId, BatchNodeFilesListOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createPool(BatchPoolCreateParameters pool, BatchPoolCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createPool(BatchPoolCreateParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePool(String poolId, BatchPoolUpdateParameters pool, BatchPoolUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePool(String poolId, BatchPoolUpdateParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void resizePool(String poolId, BatchPoolResizeParameters parameters, BatchPoolResizeOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, BatchPool> beginResizePool(String poolId, BatchPoolResizeParameters parameters, BatchPoolResizeOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginResizePool(poolId, parameters, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void resizePool(String poolId, BatchPoolResizeParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, BatchPool> beginResizePool(String poolId, BatchPoolResizeParameters parameters) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginResizePool(poolId, parameters);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replacePoolProperties(String poolId, BatchPoolReplaceParameters pool, BatchPoolPropertiesReplaceOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replacePoolProperties(String poolId, BatchPoolReplaceParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void removeNodes(String poolId, BatchNodeRemoveParameters parameters, BatchNodesRemoveOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<BatchPool, BatchPool> beginRemoveNodes(String poolId, BatchNodeRemoveParameters parameters, BatchNodesRemoveOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginRemoveNodes(poolId, parameters, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void removeNodes(String poolId, BatchNodeRemoveParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchPool, BatchPool> beginRemoveNodes(String poolId, BatchNodeRemoveParameters parameters) {
        PollerFlux<BatchPool, BatchPool> asyncPoller = this.asyncClient.beginRemoveNodes(poolId, parameters);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJob(String jobId, BatchJobUpdateParameters job, BatchJobUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJob(String jobId, BatchJobUpdateParameters job) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void disableJob(String jobId, BatchJobDisableParameters parameters, BatchJobDisableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginDisableJob(String jobId, BatchJobDisableParameters parameters, BatchJobDisableOptions options, RequestConditions requestConditions) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginDisableJob(jobId, parameters, options, requestConditions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void disableJob(String jobId, BatchJobDisableParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BatchJob, BatchJob> beginDisableJob(String jobId, BatchJobDisableParameters parameters) {
        PollerFlux<BatchJob, BatchJob> asyncPoller = this.asyncClient.beginDisableJob(jobId, parameters);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJob(BatchJobCreateParameters job, BatchJobCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJob(BatchJobCreateParameters job) {
        RequestOptions requestOptions = new RequestOptions();
        this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateParameters jobSchedule, BatchJobScheduleUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateParameters jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJobSchedule(BatchJobScheduleCreateParameters jobSchedule, BatchJobScheduleCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJobSchedule(BatchJobScheduleCreateParameters jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTask(String jobId, BatchTaskCreateParameters task, BatchTaskCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTask(String jobId, BatchTaskCreateParameters task) {
        RequestOptions requestOptions = new RequestOptions();
        this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createNodeUser(String poolId, String nodeId, BatchNodeUserCreateParameters user, BatchNodeUserCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createNodeUser(String poolId, String nodeId, BatchNodeUserCreateParameters user) {
        RequestOptions requestOptions = new RequestOptions();
        this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateParameters parameters, BatchNodeUserReplaceOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadBatchServiceLogsResult uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsParameters parameters, BatchNodeLogsUploadOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (UploadBatchServiceLogsResult)((BinaryData)this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)parameters), requestOptions).getValue()).toObject(UploadBatchServiceLogsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadBatchServiceLogsResult uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return (UploadBatchServiceLogsResult)((BinaryData)this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)parameters), requestOptions).getValue()).toObject(UploadBatchServiceLogsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoScaleRun evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return (AutoScaleRun)((BinaryData)this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue()).toObject(AutoScaleRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleParameters parameters, BatchPoolEnableAutoScaleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoScaleRun evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleParameters parameters, BatchPoolEvaluateAutoScaleOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return (AutoScaleRun)((BinaryData)this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).getValue()).toObject(AutoScaleRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disablePoolAutoScale(String poolId, BatchPoolDisableAutoScaleOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        this.disablePoolAutoScaleWithResponse(poolId, requestOptions).getValue();
    }
}

