/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchClientBuilder;
import com.azure.compute.batch.CertificateDeletePollerAsync;
import com.azure.compute.batch.JobDeletePollerAsync;
import com.azure.compute.batch.JobDisablePollerAsync;
import com.azure.compute.batch.JobEnablePollerAsync;
import com.azure.compute.batch.JobScheduleDeletePollerAsync;
import com.azure.compute.batch.JobScheduleTerminatePollerAsync;
import com.azure.compute.batch.JobTerminatePollerAsync;
import com.azure.compute.batch.NodeDeallocatePollerAsync;
import com.azure.compute.batch.NodeRebootPollerAsync;
import com.azure.compute.batch.NodeReimagePollerAsync;
import com.azure.compute.batch.NodeRemovePollerAsync;
import com.azure.compute.batch.NodeStartPollerAsync;
import com.azure.compute.batch.PoolDeletePollerAsync;
import com.azure.compute.batch.PoolResizePollerAsync;
import com.azure.compute.batch.PoolStopResizePollerAsync;
import com.azure.compute.batch.implementation.BatchClientImpl;
import com.azure.compute.batch.implementation.task.AsyncClientTaskSubmitter;
import com.azure.compute.batch.implementation.task.TaskManager;
import com.azure.compute.batch.models.AutoScaleRun;
import com.azure.compute.batch.models.BatchApplication;
import com.azure.compute.batch.models.BatchApplicationGetOptions;
import com.azure.compute.batch.models.BatchApplicationsListOptions;
import com.azure.compute.batch.models.BatchCertificate;
import com.azure.compute.batch.models.BatchCertificateCancelDeletionOptions;
import com.azure.compute.batch.models.BatchCertificateCreateOptions;
import com.azure.compute.batch.models.BatchCertificateDeleteOptions;
import com.azure.compute.batch.models.BatchCertificateGetOptions;
import com.azure.compute.batch.models.BatchCertificatesListOptions;
import com.azure.compute.batch.models.BatchCreateTaskCollectionResult;
import com.azure.compute.batch.models.BatchFileProperties;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobCreateOptions;
import com.azure.compute.batch.models.BatchJobCreateParameters;
import com.azure.compute.batch.models.BatchJobDeleteOptions;
import com.azure.compute.batch.models.BatchJobDisableOptions;
import com.azure.compute.batch.models.BatchJobDisableParameters;
import com.azure.compute.batch.models.BatchJobEnableOptions;
import com.azure.compute.batch.models.BatchJobGetOptions;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatus;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatusListOptions;
import com.azure.compute.batch.models.BatchJobReplaceOptions;
import com.azure.compute.batch.models.BatchJobSchedule;
import com.azure.compute.batch.models.BatchJobScheduleCreateOptions;
import com.azure.compute.batch.models.BatchJobScheduleCreateParameters;
import com.azure.compute.batch.models.BatchJobScheduleDeleteOptions;
import com.azure.compute.batch.models.BatchJobScheduleDisableOptions;
import com.azure.compute.batch.models.BatchJobScheduleEnableOptions;
import com.azure.compute.batch.models.BatchJobScheduleExistsOptions;
import com.azure.compute.batch.models.BatchJobScheduleGetOptions;
import com.azure.compute.batch.models.BatchJobScheduleReplaceOptions;
import com.azure.compute.batch.models.BatchJobScheduleTerminateOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateParameters;
import com.azure.compute.batch.models.BatchJobSchedulesListOptions;
import com.azure.compute.batch.models.BatchJobTaskCountsGetOptions;
import com.azure.compute.batch.models.BatchJobTerminateOptions;
import com.azure.compute.batch.models.BatchJobTerminateParameters;
import com.azure.compute.batch.models.BatchJobUpdateOptions;
import com.azure.compute.batch.models.BatchJobUpdateParameters;
import com.azure.compute.batch.models.BatchJobsFromScheduleListOptions;
import com.azure.compute.batch.models.BatchJobsListOptions;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeDeallocateOptions;
import com.azure.compute.batch.models.BatchNodeDeallocateParameters;
import com.azure.compute.batch.models.BatchNodeDisableSchedulingParameters;
import com.azure.compute.batch.models.BatchNodeExtensionGetOptions;
import com.azure.compute.batch.models.BatchNodeExtensionsListOptions;
import com.azure.compute.batch.models.BatchNodeFile;
import com.azure.compute.batch.models.BatchNodeFileDeleteOptions;
import com.azure.compute.batch.models.BatchNodeFileGetOptions;
import com.azure.compute.batch.models.BatchNodeFilePropertiesGetOptions;
import com.azure.compute.batch.models.BatchNodeFilesListOptions;
import com.azure.compute.batch.models.BatchNodeGetOptions;
import com.azure.compute.batch.models.BatchNodeLogsUploadOptions;
import com.azure.compute.batch.models.BatchNodeRebootOptions;
import com.azure.compute.batch.models.BatchNodeRebootParameters;
import com.azure.compute.batch.models.BatchNodeReimageOptions;
import com.azure.compute.batch.models.BatchNodeReimageParameters;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettings;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettingsGetOptions;
import com.azure.compute.batch.models.BatchNodeRemoveParameters;
import com.azure.compute.batch.models.BatchNodeSchedulingDisableOptions;
import com.azure.compute.batch.models.BatchNodeSchedulingEnableOptions;
import com.azure.compute.batch.models.BatchNodeStartOptions;
import com.azure.compute.batch.models.BatchNodeUserCreateOptions;
import com.azure.compute.batch.models.BatchNodeUserCreateParameters;
import com.azure.compute.batch.models.BatchNodeUserDeleteOptions;
import com.azure.compute.batch.models.BatchNodeUserReplaceOptions;
import com.azure.compute.batch.models.BatchNodeUserUpdateParameters;
import com.azure.compute.batch.models.BatchNodeVMExtension;
import com.azure.compute.batch.models.BatchNodesListOptions;
import com.azure.compute.batch.models.BatchNodesRemoveOptions;
import com.azure.compute.batch.models.BatchPool;
import com.azure.compute.batch.models.BatchPoolCreateOptions;
import com.azure.compute.batch.models.BatchPoolCreateParameters;
import com.azure.compute.batch.models.BatchPoolDeleteOptions;
import com.azure.compute.batch.models.BatchPoolDisableAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleParameters;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleOptions;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleParameters;
import com.azure.compute.batch.models.BatchPoolExistsOptions;
import com.azure.compute.batch.models.BatchPoolGetOptions;
import com.azure.compute.batch.models.BatchPoolNodeCounts;
import com.azure.compute.batch.models.BatchPoolNodeCountsListOptions;
import com.azure.compute.batch.models.BatchPoolPropertiesReplaceOptions;
import com.azure.compute.batch.models.BatchPoolReplaceParameters;
import com.azure.compute.batch.models.BatchPoolResizeOptions;
import com.azure.compute.batch.models.BatchPoolResizeParameters;
import com.azure.compute.batch.models.BatchPoolResizeStopOptions;
import com.azure.compute.batch.models.BatchPoolUpdateOptions;
import com.azure.compute.batch.models.BatchPoolUpdateParameters;
import com.azure.compute.batch.models.BatchPoolUsageMetrics;
import com.azure.compute.batch.models.BatchPoolUsageMetricsListOptions;
import com.azure.compute.batch.models.BatchPoolsListOptions;
import com.azure.compute.batch.models.BatchSubTasksListOptions;
import com.azure.compute.batch.models.BatchSubtask;
import com.azure.compute.batch.models.BatchSupportedImage;
import com.azure.compute.batch.models.BatchTask;
import com.azure.compute.batch.models.BatchTaskBulkCreateOptions;
import com.azure.compute.batch.models.BatchTaskCollectionCreateOptions;
import com.azure.compute.batch.models.BatchTaskCountsResult;
import com.azure.compute.batch.models.BatchTaskCreateOptions;
import com.azure.compute.batch.models.BatchTaskCreateParameters;
import com.azure.compute.batch.models.BatchTaskDeleteOptions;
import com.azure.compute.batch.models.BatchTaskFileDeleteOptions;
import com.azure.compute.batch.models.BatchTaskFileGetOptions;
import com.azure.compute.batch.models.BatchTaskFilePropertiesGetOptions;
import com.azure.compute.batch.models.BatchTaskFilesListOptions;
import com.azure.compute.batch.models.BatchTaskGetOptions;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.BatchTaskReactivateOptions;
import com.azure.compute.batch.models.BatchTaskReplaceOptions;
import com.azure.compute.batch.models.BatchTaskTerminateOptions;
import com.azure.compute.batch.models.BatchTasksListOptions;
import com.azure.compute.batch.models.SupportedBatchImagesListOptions;
import com.azure.compute.batch.models.UploadBatchServiceLogsParameters;
import com.azure.compute.batch.models.UploadBatchServiceLogsResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BatchClientBuilder.class, isAsync=true)
public final class BatchAsyncClient {
    private final BatchClientImpl serviceClient;

    BatchAsyncClient(BatchClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTasks(String jobId, List<BatchTaskCreateParameters> taskList) {
        return this.createTasks(jobId, taskList, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTasks(String jobId, Collection<BatchTaskCreateParameters> taskList, BatchTaskBulkCreateOptions batchTaskBulkCreateOptions) {
        return Mono.create(sink -> {
            AsyncClientTaskSubmitter taskSubmitter = new AsyncClientTaskSubmitter(this);
            try {
                TaskManager.createTasks(taskSubmitter, jobId, taskList, batchTaskBulkCreateOptions);
                sink.success();
            }
            catch (Throwable t) {
                sink.error(t);
            }
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listApplications(RequestOptions requestOptions) {
        return this.serviceClient.listApplicationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getApplicationWithResponse(String applicationId, RequestOptions requestOptions) {
        return this.serviceClient.getApplicationWithResponseAsync(applicationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolUsageMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listPoolUsageMetricsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createPoolWithResponse(BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.createPoolWithResponseAsync(pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPools(RequestOptions requestOptions) {
        return this.serviceClient.listPoolsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> deletePoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.deletePoolWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> poolExistsWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.poolExistsWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getPoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePoolWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.updatePoolWithResponseAsync(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disablePoolAutoScaleWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.disablePoolAutoScaleWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enablePoolAutoScaleWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.enablePoolAutoScaleWithResponseAsync(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> evaluatePoolAutoScaleWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.evaluatePoolAutoScaleWithResponseAsync(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> resizePoolWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.resizePoolWithResponseAsync(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> stopPoolResizeWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.stopPoolResizeWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replacePoolPropertiesWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.replacePoolPropertiesWithResponseAsync(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> removeNodesWithResponse(String poolId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.removeNodesWithResponseAsync(poolId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSupportedImages(RequestOptions requestOptions) {
        return this.serviceClient.listSupportedImagesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolNodeCounts(RequestOptions requestOptions) {
        return this.serviceClient.listPoolNodeCountsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> deleteJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.updateJobWithResponseAsync(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobWithResponseAsync(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> disableJobWithResponse(String jobId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.disableJobWithResponseAsync(jobId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> enableJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> terminateJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobWithResponse(BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.createJobWithResponseAsync(job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobs(RequestOptions requestOptions) {
        return this.serviceClient.listJobsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobsFromSchedule(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.listJobsFromScheduleAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobPreparationAndReleaseTaskStatus(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listJobPreparationAndReleaseTaskStatusAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobTaskCountsWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobTaskCountsWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createCertificateWithResponse(BinaryData certificate, RequestOptions requestOptions) {
        return this.serviceClient.createCertificateWithResponseAsync(certificate, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCertificates(RequestOptions requestOptions) {
        return this.serviceClient.listCertificatesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelCertificateDeletionWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.cancelCertificateDeletionWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> deleteCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.deleteCertificateWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.getCertificateWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> jobScheduleExistsWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.jobScheduleExistsWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> deleteJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.getJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.updateJobScheduleWithResponseAsync(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobScheduleWithResponseAsync(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.disableJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> terminateJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobScheduleWithResponse(BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.createJobScheduleWithResponseAsync(jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobSchedules(RequestOptions requestOptions) {
        return this.serviceClient.listJobSchedulesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createTaskWithResponse(String jobId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.createTaskWithResponseAsync(jobId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTasks(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listTasksAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createTaskCollectionWithResponse(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        return this.serviceClient.createTaskCollectionWithResponseAsync(jobId, taskCollection, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.getTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceTaskWithResponse(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.replaceTaskWithResponseAsync(jobId, taskId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSubTasks(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listSubTasksAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.terminateTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reactivateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.reactivateTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskFileWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFileWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getTaskFilePropertiesWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFilePropertiesWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTaskFiles(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listTaskFilesAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNodeUserWithResponse(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        return this.serviceClient.createNodeUserWithResponseAsync(poolId, nodeId, user, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeUserWithResponse(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeUserWithResponseAsync(poolId, nodeId, userName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceNodeUserWithResponse(String poolId, String nodeId, String userName, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.replaceNodeUserWithResponseAsync(poolId, nodeId, userName, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> rebootNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.rebootNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> startNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.startNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> reimageNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.reimageNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<Void>> deallocateNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.deallocateNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.disableNodeSchedulingWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.enableNodeSchedulingWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeRemoteLoginSettingsWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeRemoteLoginSettingsWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> uploadNodeLogsWithResponse(String poolId, String nodeId, BinaryData parameters, RequestOptions requestOptions) {
        return this.serviceClient.uploadNodeLogsWithResponseAsync(poolId, nodeId, parameters, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodes(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.listNodesAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeExtensionWithResponse(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        return this.serviceClient.getNodeExtensionWithResponseAsync(poolId, nodeId, extensionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeExtensions(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeExtensionsAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeFileWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFileWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getNodeFilePropertiesWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFilePropertiesWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeFiles(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeFilesAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchApplication> listApplications() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listApplications(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchApplication> getApplication(String applicationId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getApplicationWithResponse(applicationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolUsageMetrics> listPoolUsageMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolUsageMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolUsageMetrics)protocolMethodData.toObject(BatchPoolUsageMetrics.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPool> listPools() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPools(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deletePool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deletePoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, Void> beginDeletePool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        PoolDeletePollerAsync poller = new PoolDeletePollerAsync(this, poolId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> poolExists(String poolId, BatchPoolExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.poolExistsWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> poolExists(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.poolExistsWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchPool> getPool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getPoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disablePoolAutoScale(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disablePoolAutoScaleWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> stopPoolResize(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.stopPoolResizeWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginStopPoolResize(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        PoolStopResizePollerAsync poller = new PoolStopResizePollerAsync(this, poolId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSupportedImage> listSupportedImages() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listSupportedImages(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSupportedImage)protocolMethodData.toObject(BatchSupportedImage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolNodeCounts> listPoolNodeCounts() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolNodeCounts(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolNodeCounts)protocolMethodData.toObject(BatchPoolNodeCounts.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, Void> beginDeleteJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        JobDeletePollerAsync poller = new JobDeletePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJob> getJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJob(String jobId, BatchJob job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> enableJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginEnableJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        JobEnablePollerAsync poller = new JobEnablePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> terminateJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginTerminateJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        JobTerminatePollerAsync poller = new JobTerminatePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobs() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobs(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobsFromSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobsFromSchedule(jobScheduleId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobPreparationAndReleaseTaskStatus)protocolMethodData.toObject(BatchJobPreparationAndReleaseTaskStatus.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskCountsResult> getJobTaskCounts(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobTaskCountsWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskCountsResult)protocolMethodData.toObject(BatchTaskCountsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCertificate(BatchCertificate certificate) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchCertificate> listCertificates() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listCertificates(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchCertificate, Void> beginDeleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        CertificateDeletePollerAsync poller = new CertificateDeletePollerAsync(this, thumbprintAlgorithm, thumbprint, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchCertificate> getCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> jobScheduleExists(String jobScheduleId, BatchJobScheduleExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> jobScheduleExists(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJobSchedule, Void> beginDeleteJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        JobScheduleDeletePollerAsync poller = new JobScheduleDeletePollerAsync(this, jobScheduleId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJobSchedule> getJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> terminateJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJobSchedule, BatchJobSchedule> beginTerminateJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        JobScheduleTerminatePollerAsync poller = new JobScheduleTerminatePollerAsync(this, jobScheduleId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobSchedule> listJobSchedules() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobSchedules(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchTask> listTasks(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTasks(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchCreateTaskCollectionResult> createTaskCollection(String jobId, BatchTaskGroup taskCollection) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchCreateTaskCollectionResult)protocolMethodData.toObject(BatchCreateTaskCollectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTask> getTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceTask(String jobId, String taskId, BatchTask task) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSubtask> listSubTasks(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listSubTasks(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSubtask)protocolMethodData.toObject(BatchSubtask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reactivateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.reactivateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchFileProperties> getTaskFileProperties(String jobId, String taskId, String filePath, BatchTaskFilePropertiesGetOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        return this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions).map(response -> new BatchFileProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchFileProperties> getTaskFileProperties(String jobId, String taskId, String filePath) {
        return this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, new RequestOptions()).map(response -> new BatchFileProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listTaskFiles(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTaskFiles(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeUser(String poolId, String nodeId, String userName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNode> getNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> rebootNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.rebootNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginRebootNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        NodeRebootPollerAsync poller = new NodeRebootPollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> startNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.startNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginStartNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        NodeStartPollerAsync poller = new NodeStartPollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> reimageNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.reimageNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginReimageNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        NodeReimagePollerAsync poller = new NodeReimagePollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deallocateNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginDeallocateNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        NodeDeallocatePollerAsync poller = new NodeDeallocatePollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeRemoteLoginSettings> getNodeRemoteLoginSettings(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeRemoteLoginSettings)protocolMethodData.toObject(BatchNodeRemoteLoginSettings.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNode> listNodes(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodes(poolId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeVMExtension> getNodeExtension(String poolId, String nodeId, String extensionName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeExtensions(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchFileProperties> getNodeFileProperties(String poolId, String nodeId, String filePath, BatchNodeFilePropertiesGetOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        return this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions).map(response -> new BatchFileProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchFileProperties> getNodeFileProperties(String poolId, String nodeId, String filePath) {
        return this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, new RequestOptions()).map(response -> new BatchFileProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listNodeFiles(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeFiles(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchApplication> listApplications(BatchApplicationsListOptions options) {
        Integer maxPageSize;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer n = maxPageSize = options == null ? null : options.getMaxPageSize();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listApplications(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchApplication> getApplication(String applicationId, BatchApplicationGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.getApplicationWithResponse(applicationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolUsageMetrics> listPoolUsageMetrics(BatchPoolUsageMetricsListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        OffsetDateTime startTime = options == null ? null : options.getStartTime();
        OffsetDateTime endtime = options == null ? null : options.getEndtime();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (startTime != null) {
            requestOptions.addQueryParam("startTime", String.valueOf(startTime), false);
        }
        if (endtime != null) {
            requestOptions.addQueryParam("endtime", String.valueOf(endtime), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolUsageMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolUsageMetrics)protocolMethodData.toObject(BatchPoolUsageMetrics.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPool> listPools(BatchPoolsListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPools(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deletePool(String poolId, BatchPoolDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deletePoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, Void> beginDeletePool(String poolId, BatchPoolDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        PoolDeletePollerAsync poller = new PoolDeletePollerAsync(this, poolId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchPool> getPool(String poolId, BatchPoolGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getPoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> stopPoolResize(String poolId, BatchPoolResizeStopOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.stopPoolResizeWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginStopPoolResize(String poolId, BatchPoolResizeStopOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        PoolStopResizePollerAsync poller = new PoolStopResizePollerAsync(this, poolId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSupportedImage> listSupportedImages(SupportedBatchImagesListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listSupportedImages(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSupportedImage)protocolMethodData.toObject(BatchSupportedImage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolNodeCounts> listPoolNodeCounts(BatchPoolNodeCountsListOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolNodeCounts(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolNodeCounts)protocolMethodData.toObject(BatchPoolNodeCounts.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteJob(String jobId, BatchJobDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, Void> beginDeleteJob(String jobId, BatchJobDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobDeletePollerAsync poller = new JobDeletePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJob> getJob(String jobId, BatchJobGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJob(String jobId, BatchJob job, BatchJobReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> enableJob(String jobId, BatchJobEnableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enableJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginEnableJob(String jobId, BatchJobEnableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobEnablePollerAsync poller = new JobEnablePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> terminateJob(String jobId, BatchJobTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchJobTerminateParameters parameters = options == null ? null : options.getParameters();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginTerminateJob(String jobId, BatchJobTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchJobTerminateParameters parameters = options == null ? null : options.getParameters();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobTerminatePollerAsync poller = new JobTerminatePollerAsync(this, jobId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobs(BatchJobsListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobs(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobsFromSchedule(String jobScheduleId, BatchJobsFromScheduleListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobsFromSchedule(jobScheduleId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId, BatchJobPreparationAndReleaseTaskStatusListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobPreparationAndReleaseTaskStatus)protocolMethodData.toObject(BatchJobPreparationAndReleaseTaskStatus.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskCountsResult> getJobTaskCounts(String jobId, BatchJobTaskCountsGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.getJobTaskCountsWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskCountsResult)protocolMethodData.toObject(BatchTaskCountsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCertificate(BatchCertificate certificate, BatchCertificateCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchCertificate> listCertificates(BatchCertificatesListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listCertificates(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint, BatchCertificateCancelDeletionOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateDeleteOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchCertificate, Void> beginDeleteCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateDeleteOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        CertificateDeletePollerAsync poller = new CertificateDeletePollerAsync(this, thumbprintAlgorithm, thumbprint, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchCertificate> getCertificate(String thumbprintAlgorithm, String thumbprint, BatchCertificateGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deleteJobSchedule(String jobScheduleId, BatchJobScheduleDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJobSchedule, Void> beginDeleteJobSchedule(String jobScheduleId, BatchJobScheduleDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobScheduleDeletePollerAsync poller = new JobScheduleDeletePollerAsync(this, jobScheduleId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJobSchedule> getJobSchedule(String jobScheduleId, BatchJobScheduleGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule, BatchJobScheduleReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJobSchedule(String jobScheduleId, BatchJobScheduleDisableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJobSchedule(String jobScheduleId, BatchJobScheduleEnableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> terminateJobSchedule(String jobScheduleId, BatchJobScheduleTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJobSchedule, BatchJobSchedule> beginTerminateJobSchedule(String jobScheduleId, BatchJobScheduleTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobScheduleTerminatePollerAsync poller = new JobScheduleTerminatePollerAsync(this, jobScheduleId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobSchedule> listJobSchedules(BatchJobSchedulesListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobSchedules(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchTask> listTasks(String jobId, BatchTasksListOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTasks(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchCreateTaskCollectionResult> createTaskCollection(String jobId, BatchTaskGroup taskCollection, BatchTaskCollectionCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchCreateTaskCollectionResult)protocolMethodData.toObject(BatchCreateTaskCollectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTask(String jobId, String taskId, BatchTaskDeleteOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTask> getTask(String jobId, String taskId, BatchTaskGetOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceTask(String jobId, String taskId, BatchTask task, BatchTaskReplaceOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSubtask> listSubTasks(String jobId, String taskId, BatchSubTasksListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listSubTasks(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSubtask)protocolMethodData.toObject(BatchSubtask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateTask(String jobId, String taskId, BatchTaskTerminateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reactivateTask(String jobId, String taskId, BatchTaskReactivateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.reactivateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTaskFile(String jobId, String taskId, String filePath, BatchTaskFileDeleteOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getTaskFile(String jobId, String taskId, String filePath, BatchTaskFileGetOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listTaskFiles(String jobId, String taskId, BatchTaskFilesListOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTaskFiles(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeUser(String poolId, String nodeId, String userName, BatchNodeUserDeleteOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNode> getNode(String poolId, String nodeId, BatchNodeGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> rebootNode(String poolId, String nodeId, BatchNodeRebootOptions options) {
        BatchNodeRebootParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeRebootParameters batchNodeRebootParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.rebootNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginRebootNode(String poolId, String nodeId, BatchNodeRebootOptions options) {
        BatchNodeRebootParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeRebootParameters batchNodeRebootParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        NodeRebootPollerAsync poller = new NodeRebootPollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> startNode(String poolId, String nodeId, BatchNodeStartOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.startNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginStartNode(String poolId, String nodeId, BatchNodeStartOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        NodeStartPollerAsync poller = new NodeStartPollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> reimageNode(String poolId, String nodeId, BatchNodeReimageOptions options) {
        BatchNodeReimageParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeReimageParameters batchNodeReimageParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.reimageNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginReimageNode(String poolId, String nodeId, BatchNodeReimageOptions options) {
        BatchNodeReimageParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeReimageParameters batchNodeReimageParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        NodeReimagePollerAsync poller = new NodeReimagePollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> deallocateNode(String poolId, String nodeId, BatchNodeDeallocateOptions options) {
        BatchNodeDeallocateParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDeallocateParameters batchNodeDeallocateParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchNode, BatchNode> beginDeallocateNode(String poolId, String nodeId, BatchNodeDeallocateOptions options) {
        BatchNodeDeallocateParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDeallocateParameters batchNodeDeallocateParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        NodeDeallocatePollerAsync poller = new NodeDeallocatePollerAsync(this, poolId, nodeId, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableNodeScheduling(String poolId, String nodeId, BatchNodeSchedulingDisableOptions options) {
        BatchNodeDisableSchedulingParameters parameters;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDisableSchedulingParameters batchNodeDisableSchedulingParameters = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableNodeScheduling(String poolId, String nodeId, BatchNodeSchedulingEnableOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeRemoteLoginSettings> getNodeRemoteLoginSettings(String poolId, String nodeId, BatchNodeRemoteLoginSettingsGetOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeRemoteLoginSettings)protocolMethodData.toObject(BatchNodeRemoteLoginSettings.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNode> listNodes(String poolId, BatchNodesListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodes(poolId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeVMExtension> getNodeExtension(String poolId, String nodeId, String extensionName, BatchNodeExtensionGetOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId, BatchNodeExtensionsListOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeExtensions(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeFile(String poolId, String nodeId, String filePath, BatchNodeFileDeleteOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getNodeFile(String poolId, String nodeId, String filePath, BatchNodeFileGetOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listNodeFiles(String poolId, String nodeId, BatchNodeFilesListOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Integer maxPageSize = options == null ? null : options.getMaxPageSize();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (maxPageSize != null) {
            requestOptions.addQueryParam("maxresults", String.valueOf(maxPageSize), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeFiles(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPool(BatchPoolCreateParameters pool, BatchPoolCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPool(BatchPoolCreateParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePool(String poolId, BatchPoolUpdateParameters pool, BatchPoolUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePool(String poolId, BatchPoolUpdateParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> resizePool(String poolId, BatchPoolResizeParameters parameters, BatchPoolResizeOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginResizePool(String poolId, BatchPoolResizeParameters parameters, BatchPoolResizeOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        PoolResizePollerAsync poller = new PoolResizePollerAsync(this, poolId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> resizePool(String poolId, BatchPoolResizeParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginResizePool(String poolId, BatchPoolResizeParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        PoolResizePollerAsync poller = new PoolResizePollerAsync(this, poolId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replacePoolProperties(String poolId, BatchPoolReplaceParameters pool, BatchPoolPropertiesReplaceOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replacePoolProperties(String poolId, BatchPoolReplaceParameters pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> removeNodes(String poolId, BatchNodeRemoveParameters parameters, BatchNodesRemoveOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginRemoveNodes(String poolId, BatchNodeRemoveParameters parameters, BatchNodesRemoveOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        NodeRemovePollerAsync poller = new NodeRemovePollerAsync(this, poolId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> removeNodes(String poolId, BatchNodeRemoveParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchPool, BatchPool> beginRemoveNodes(String poolId, BatchNodeRemoveParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        NodeRemovePollerAsync poller = new NodeRemovePollerAsync(this, poolId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJob(String jobId, BatchJobUpdateParameters job, BatchJobUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJob(String jobId, BatchJobUpdateParameters job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> disableJob(String jobId, BatchJobDisableParameters parameters, BatchJobDisableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginDisableJob(String jobId, BatchJobDisableParameters parameters, BatchJobDisableOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        JobDisablePollerAsync poller = new JobDisablePollerAsync(this, jobId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Void> disableJob(String jobId, BatchJobDisableParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BatchJob, BatchJob> beginDisableJob(String jobId, BatchJobDisableParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        JobDisablePollerAsync poller = new JobDisablePollerAsync(this, jobId, parameters, requestOptions);
        return PollerFlux.create((Duration)Duration.ofSeconds(5L), poller.getActivationOperation(), poller.getPollOperation(), poller.getCancelOperation(), poller.getFetchResultOperation());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJob(BatchJobCreateParameters job, BatchJobCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJob(BatchJobCreateParameters job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateParameters jobSchedule, BatchJobScheduleUpdateOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateParameters jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJobSchedule(BatchJobScheduleCreateParameters jobSchedule, BatchJobScheduleCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJobSchedule(BatchJobScheduleCreateParameters jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTask(String jobId, BatchTaskCreateParameters task, BatchTaskCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTask(String jobId, BatchTaskCreateParameters task) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createNodeUser(String poolId, String nodeId, BatchNodeUserCreateParameters user, BatchNodeUserCreateOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createNodeUser(String poolId, String nodeId, BatchNodeUserCreateParameters user) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateParameters parameters, BatchNodeUserReplaceOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UploadBatchServiceLogsResult> uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsParameters parameters, BatchNodeLogsUploadOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UploadBatchServiceLogsResult)protocolMethodData.toObject(UploadBatchServiceLogsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UploadBatchServiceLogsResult> uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UploadBatchServiceLogsResult)protocolMethodData.toObject(UploadBatchServiceLogsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutoScaleRun> evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleParameters parameters) {
        RequestOptions requestOptions = new RequestOptions();
        return this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AutoScaleRun)protocolMethodData.toObject(AutoScaleRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleParameters parameters, BatchPoolEnableAutoScaleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Duration timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutoScaleRun> evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleParameters parameters, BatchPoolEvaluateAutoScaleOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)parameters), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AutoScaleRun)protocolMethodData.toObject(AutoScaleRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disablePoolAutoScale(String poolId, BatchPoolDisableAutoScaleOptions options) {
        Duration timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Duration duration = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds.getSeconds()), false);
        }
        return this.disablePoolAutoScaleWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }
}

