/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeIdentityReference;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class UploadBatchServiceLogsContent
implements JsonSerializable<UploadBatchServiceLogsContent> {
    private final String containerUrl;
    private final OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private BatchNodeIdentityReference identityReference;

    public UploadBatchServiceLogsContent(String containerUrl, OffsetDateTime startTime) {
        this.containerUrl = containerUrl;
        this.startTime = startTime;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public UploadBatchServiceLogsContent setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public BatchNodeIdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public UploadBatchServiceLogsContent setIdentityReference(BatchNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static UploadBatchServiceLogsContent fromJson(JsonReader jsonReader) throws IOException {
        return (UploadBatchServiceLogsContent)jsonReader.readObject(reader -> {
            String containerUrl = null;
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            BatchNodeIdentityReference identityReference = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    identityReference = BatchNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            UploadBatchServiceLogsContent deserializedUploadBatchServiceLogsContent = new UploadBatchServiceLogsContent(containerUrl, startTime);
            deserializedUploadBatchServiceLogsContent.endTime = endTime;
            deserializedUploadBatchServiceLogsContent.identityReference = identityReference;
            return deserializedUploadBatchServiceLogsContent;
        });
    }
}

