/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.SecurityTypes;
import com.azure.compute.batch.models.UefiSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SecurityProfile
implements JsonSerializable<SecurityProfile> {
    private final boolean encryptionAtHost;
    private final SecurityTypes securityType;
    private final UefiSettings uefiSettings;

    public SecurityProfile(boolean encryptionAtHost, SecurityTypes securityType, UefiSettings uefiSettings) {
        this.encryptionAtHost = encryptionAtHost;
        this.securityType = securityType;
        this.uefiSettings = uefiSettings;
    }

    public boolean isEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    public SecurityTypes getSecurityType() {
        return this.securityType;
    }

    public UefiSettings getUefiSettings() {
        return this.uefiSettings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("encryptionAtHost", this.encryptionAtHost);
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        jsonWriter.writeJsonField("uefiSettings", (JsonSerializable)this.uefiSettings);
        return jsonWriter.writeEndObject();
    }

    public static SecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityProfile)jsonReader.readObject(reader -> {
            boolean encryptionAtHost = false;
            SecurityTypes securityType = null;
            UefiSettings uefiSettings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encryptionAtHost".equals(fieldName)) {
                    encryptionAtHost = reader.getBoolean();
                    continue;
                }
                if ("securityType".equals(fieldName)) {
                    securityType = SecurityTypes.fromString(reader.getString());
                    continue;
                }
                if ("uefiSettings".equals(fieldName)) {
                    uefiSettings = UefiSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new SecurityProfile(encryptionAtHost, securityType, uefiSettings);
        });
    }
}

