/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchPoolEndpointConfiguration;
import com.azure.compute.batch.models.DynamicVNetAssignmentScope;
import com.azure.compute.batch.models.PublicIpAddressConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class NetworkConfiguration
implements JsonSerializable<NetworkConfiguration> {
    private String subnetId;
    private DynamicVNetAssignmentScope dynamicVNetAssignmentScope;
    private BatchPoolEndpointConfiguration endpointConfiguration;
    private PublicIpAddressConfiguration publicIpAddressConfiguration;
    private Boolean enableAcceleratedNetworking;

    public String getSubnetId() {
        return this.subnetId;
    }

    public NetworkConfiguration setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public DynamicVNetAssignmentScope getDynamicVNetAssignmentScope() {
        return this.dynamicVNetAssignmentScope;
    }

    public NetworkConfiguration setDynamicVNetAssignmentScope(DynamicVNetAssignmentScope dynamicVNetAssignmentScope) {
        this.dynamicVNetAssignmentScope = dynamicVNetAssignmentScope;
        return this;
    }

    public BatchPoolEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public NetworkConfiguration setEndpointConfiguration(BatchPoolEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this;
    }

    public PublicIpAddressConfiguration getPublicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    public NetworkConfiguration setPublicIpAddressConfiguration(PublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    public Boolean isEnableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public NetworkConfiguration setEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("dynamicVNetAssignmentScope", this.dynamicVNetAssignmentScope == null ? null : this.dynamicVNetAssignmentScope.toString());
        jsonWriter.writeJsonField("endpointConfiguration", (JsonSerializable)this.endpointConfiguration);
        jsonWriter.writeJsonField("publicIPAddressConfiguration", (JsonSerializable)this.publicIpAddressConfiguration);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkConfiguration)jsonReader.readObject(reader -> {
            NetworkConfiguration deserializedNetworkConfiguration = new NetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedNetworkConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("dynamicVNetAssignmentScope".equals(fieldName)) {
                    deserializedNetworkConfiguration.dynamicVNetAssignmentScope = DynamicVNetAssignmentScope.fromString(reader.getString());
                    continue;
                }
                if ("endpointConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.endpointConfiguration = BatchPoolEndpointConfiguration.fromJson(reader);
                    continue;
                }
                if ("publicIPAddressConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.publicIpAddressConfiguration = PublicIpAddressConfiguration.fromJson(reader);
                    continue;
                }
                if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedNetworkConfiguration.enableAcceleratedNetworking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfiguration;
        });
    }
}

